/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.coffeescript;

import java.io.IOException;
import org.hibnet.webpipes.processor.rhino.RhinoBasedProcessor;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.ResourceFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class CoffeeScriptProcessor
extends RhinoBasedProcessor {
    private String[] options;

    public CoffeeScriptProcessor(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public void setOptions(String ... options) {
        this.options = options;
    }

    @Override
    protected void initScope(Context context, ScriptableObject globalScope) throws IOException {
        this.evaluateFromWebjar(context, (Scriptable)globalScope, "coffee-script.min.js");
    }

    @Override
    protected String process(Context context, Scriptable scope, Resource resource, String content) throws Exception {
        StringBuilder script = new StringBuilder("CoffeeScript.compile(");
        script.append(this.toJSMultiLineString(content));
        script.append(",{");
        if (this.options != null) {
            for (int i = 0; i < this.options.length; ++i) {
                script.append(this.options[i]).append(": true");
                if (i >= this.options.length - 1) continue;
                script.append(",");
            }
        }
        script.append("});");
        return (String)this.evaluate(context, scope, script.toString());
    }
}

