/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.emberjs;

import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.hibnet.webpipes.processor.rhino.RhinoBasedProcessor;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.ResourceFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class EmberJsProcessor
extends RhinoBasedProcessor {
    public EmberJsProcessor(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    @Override
    protected void initScope(Context context, ScriptableObject globalScope) throws IOException {
        this.addCommon(context, (Scriptable)globalScope);
        this.addClientSideEnvironment(context, (Scriptable)globalScope);
        this.evaluateFromWebjar(context, (Scriptable)globalScope, "jquery.js");
        this.evaluateFromWebjar(context, (Scriptable)globalScope, "handlebars.js");
        this.evaluateFromWebjar(context, (Scriptable)globalScope, "ember.js");
        this.evaluateFromClasspath(context, (Scriptable)globalScope, "/org/hibnet/webpipes/processor/emberjs/headless-rhino.js");
    }

    @Override
    protected String process(Context context, Scriptable scope, Resource resource, String content) throws Exception {
        String name = resource == null ? "" : FilenameUtils.getBaseName((String)resource.getName());
        String script = this.buildSimpleRunScript("precompile", content, new String[0]);
        String result = (String)this.evaluate(context, scope, script);
        return "(function() {Ember.TEMPLATES['" + name + "'] = Ember.Handlebars.template(" + result + ")})();";
    }
}

