/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.googleclosure;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import org.hibnet.webpipes.processor.ObjectPoolHelper;
import org.hibnet.webpipes.processor.ResourceProcessor;
import org.hibnet.webpipes.resource.Resource;

public class GoogleClosureCompressorProcessor
extends ResourceProcessor {
    private CompilationLevel compilationLevel;
    private ObjectPoolHelper<CompilerOptions> optionsPool = new ObjectPoolHelper<CompilerOptions>(new ObjectPoolHelper.ObjectFactory<CompilerOptions>(){

        @Override
        public CompilerOptions create() {
            return GoogleClosureCompressorProcessor.this.newCompilerOptions();
        }
    });

    public GoogleClosureCompressorProcessor() {
        this(CompilationLevel.SIMPLE_OPTIMIZATIONS);
    }

    public void setCompilationLevel(CompilationLevel compilationLevel) {
        this.compilationLevel = compilationLevel;
    }

    public GoogleClosureCompressorProcessor(CompilationLevel compilationLevel) {
        this.compilationLevel = compilationLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(Resource resource, String content) throws IOException {
        block5: {
            CompilerOptions compilerOptions = this.optionsPool.getObject();
            Compiler compiler = this.newCompiler(compilerOptions);
            try {
                String fileName = resource == null ? "wro4j-processed-file.js" : resource.getName();
                SourceFile[] input = new SourceFile[]{SourceFile.fromCode((String)fileName, (String)content)};
                SourceFile[] externs = this.getExterns(resource);
                if (externs == null) {
                    externs = new SourceFile[]{};
                }
                Result result = null;
                result = compiler.compile(Arrays.asList(externs), Arrays.asList(input), compilerOptions);
                if (result.success) {
                    content = compiler.toSource();
                    break block5;
                }
                throw new RuntimeException("Compilation has errors: " + Arrays.asList(result.errors));
            }
            finally {
                this.optionsPool.returnObject(compilerOptions);
            }
        }
        return content;
    }

    private Compiler newCompiler(CompilerOptions compilerOptions) {
        Compiler.setLoggingLevel((Level)Level.SEVERE);
        Compiler compiler = new Compiler();
        this.compilationLevel.setOptionsForCompilationLevel(compilerOptions);
        compiler.disableThreads();
        compiler.initOptions(compilerOptions);
        return compiler;
    }

    protected SourceFile[] getExterns(Resource resource) {
        return new SourceFile[0];
    }

    protected CompilerOptions newCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        options.setCodingConvention((CodingConvention)new ClosureCodingConvention());
        options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
        return options;
    }

    @Override
    public void destroy() throws Exception {
        this.optionsPool.destroy();
    }
}

