/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.hoganjs;

import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.hibnet.webpipes.processor.rhino.RhinoBasedProcessor;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.ResourceFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class HoganJsProcessor
extends RhinoBasedProcessor {
    public HoganJsProcessor(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    @Override
    protected void initScope(Context context, ScriptableObject globalScope) throws IOException {
        this.addCommon(context, (Scriptable)globalScope);
        this.evaluateFromClasspath(context, (Scriptable)globalScope, "/org/hibnet/webpipes/processor/hoganjs/hogan-2.0.0.min.js");
    }

    @Override
    protected String process(Context context, Scriptable scope, Resource resource, String content) throws Exception {
        String name = resource == null ? "" : FilenameUtils.getBaseName((String)resource.getName());
        StringBuilder script = new StringBuilder("Hogan.compile(");
        script.append(this.toJSMultiLineString(content));
        script.append(",{asString: true});");
        String result = (String)this.evaluate(context, scope, script.toString());
        return "Hogan.cache['" + name + "'] = " + result + ";";
    }
}

