/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.jsonhpack;

import java.io.IOException;
import org.hibnet.webpipes.processor.rhino.RhinoBasedProcessor;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.ResourceFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsonHPackProcessor
extends RhinoBasedProcessor {
    private boolean pack;

    public JsonHPackProcessor(boolean pack, ResourceFactory resourceFactory) {
        super(resourceFactory);
        this.pack = pack;
    }

    @Override
    protected void initScope(Context context, ScriptableObject globalScope) throws IOException {
        this.addCommon(context, (Scriptable)globalScope);
        this.evaluateFromClasspath(context, (Scriptable)globalScope, "/org/hibnet/webpipes/processor/jsonhpack/json.hpack.min.js");
    }

    @Override
    protected String process(Context context, Scriptable scope, Resource resource, String content) throws Exception {
        boolean isEnclosed;
        if (this.pack) {
            isEnclosed = this.isEnclosedInArray(content);
            if (!isEnclosed) {
                content = "[" + content + "]";
            }
        } else {
            isEnclosed = this.isEnclosedInDoubleArray(content);
            if (!isEnclosed) {
                content = "[" + content + "]";
            }
        }
        StringBuilder script = new StringBuilder();
        if (this.pack) {
            script.append("JSON.stringify(JSON.hpack(eval(");
        } else {
            script.append("JSON.stringify(JSON.hunpack(eval(");
        }
        script.append(this.toJSMultiLineString(content));
        if (this.pack) {
            script.append("), 4));");
        } else {
            script.append(")));");
        }
        String result = (String)this.evaluate(context, scope, script.toString());
        if (!isEnclosed) {
            result = this.removeEnclosedArray(result);
        }
        return result;
    }

    private String removeEnclosedArray(String resultAsString) {
        return resultAsString.replaceFirst("(?ims)\\[", "").replaceFirst("(?ims)\\](?!.*\\])", "");
    }

    private boolean isEnclosedInArray(String rawData) {
        return rawData.matches("(?ims)^\\s*\\[.*\\]");
    }

    private boolean isEnclosedInDoubleArray(String rawData) {
        return rawData.matches("(?ims)^\\s*\\[\\[.*\\]\\]");
    }
}

