/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.less;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import java.io.IOException;
import org.hibnet.webpipes.processor.ResourceProcessor;
import org.hibnet.webpipes.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Less4jProcessor
extends ResourceProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(Less4jProcessor.class);
    private final LessCompiler compiler = new DefaultLessCompiler();

    @Override
    public String process(Resource resource, String content) throws Exception {
        LessSource.StringSource lessSource = resource != null ? new RelativeAwareLessSource(resource, content) : new LessSource.StringSource(content);
        LessCompiler.CompilationResult result = this.compiler.compile((LessSource)lessSource);
        this.logWarnings(result);
        content = result.getCss();
        return content;
    }

    private void logWarnings(LessCompiler.CompilationResult result) {
        if (!result.getWarnings().isEmpty()) {
            LOG.warn("Less warnings are:");
            for (LessCompiler.Problem problem : result.getWarnings()) {
                LOG.warn(this.problemAsString(problem));
            }
        }
    }

    private String problemAsString(LessCompiler.Problem problem) {
        return String.format("%s:%s %s.", problem.getLine(), problem.getCharacter(), problem.getMessage());
    }

    private static class RelativeAwareLessSource
    extends LessSource.StringSource {
        private final Resource resource;

        public RelativeAwareLessSource(Resource resource, String content) {
            super(content);
            this.resource = resource;
        }

        public LessSource relativeSource(String relativePath) throws LessSource.StringSourceException {
            try {
                Resource relativeResource = this.resource.resolve(relativePath);
                return new RelativeAwareLessSource(relativeResource, relativeResource.getContent());
            }
            catch (IOException e) {
                LOG.error("Failed to compute relative resource: {}", (Object)this.resource, (Object)e);
                throw new LessSource.StringSourceException();
            }
        }
    }
}

