/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.rhino;

import java.io.IOException;
import java.net.URI;
import org.hibnet.webpipes.processor.ResourceProcessor;
import org.hibnet.webpipes.resource.ClasspathResource;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.ResourceFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.commonjs.module.RequireBuilder;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RhinoBasedProcessor
extends ResourceProcessor {
    protected static Resource commonsScript = new ClasspathResource("commons.js", RhinoBasedProcessor.class);
    protected static Resource envScript = new ClasspathResource("env.rhino.min.js", RhinoBasedProcessor.class);
    protected static Resource cycleScript = new ClasspathResource("cycle.js", RhinoBasedProcessor.class);
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private ScriptableObject globalScope;
    protected ResourceFactory resourceFactory;

    public RhinoBasedProcessor(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
        Context context = this.enterContext();
        try {
            this.globalScope = context.initStandardObjects();
            this.initScope(context, this.globalScope);
            this.globalScope.sealObject();
        }
        catch (IOException e) {
            throw new RuntimeException("The resources necessary to initialize the processor could not be accessed", e);
        }
        finally {
            Context.exit();
        }
    }

    private Context enterContext() {
        Context context = Context.enter();
        context.setOptimizationLevel(-1);
        context.setErrorReporter((ErrorReporter)new ToolErrorReporter(false));
        context.setLanguageVersion(180);
        return context;
    }

    protected abstract void initScope(Context var1, ScriptableObject var2) throws IOException;

    protected void addCommon(Context context, Scriptable scope) throws IOException {
        this.evaluate(context, scope, commonsScript);
    }

    protected void addClientSideEnvironment(Context context, Scriptable scope) throws IOException {
        this.evaluate(context, scope, envScript);
    }

    public void addJSON(Context context, Scriptable scope) throws IOException {
        this.evaluateFromWebjar(context, scope, "20110223/json2.js");
        this.evaluate(context, scope, cycleScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(Resource resource, String content) throws Exception {
        Context context = this.enterContext();
        try {
            Scriptable scope = context.newObject((Scriptable)this.globalScope);
            scope.setPrototype(null);
            scope.setParentScope((Scriptable)this.globalScope);
            content = this.process(context, scope, resource, content);
        }
        finally {
            Context.exit();
        }
        return content;
    }

    protected abstract String process(Context var1, Scriptable var2, Resource var3, String var4) throws Exception;

    protected <T> T evaluate(Context context, Scriptable scope, String script, String sourceName) {
        Object result = context.evaluateString(scope, script, sourceName, 1, null);
        return (T)result;
    }

    protected <T> T evaluate(Context context, Scriptable scope, String script) {
        return this.evaluate(context, scope, script, this.getClass().getSimpleName());
    }

    protected <T> T evaluate(Context context, Scriptable scope, Resource script) throws IOException {
        return this.evaluate(context, scope, script.getContent(), script.getName());
    }

    protected <T> T evaluateFromClasspath(Context context, Scriptable scope, String path) throws IOException {
        return this.evaluate(context, scope, this.resourceFactory.get("classpath", path));
    }

    protected <T> T evaluateFromWebjar(Context context, Scriptable scope, String path) throws IOException {
        return this.evaluate(context, scope, this.resourceFactory.get("webjar", path));
    }

    protected Scriptable setupModule(Context context, Scriptable scope, final Resource moduleResource, String moduleId) {
        RequireBuilder requireBuilder = new RequireBuilder();
        requireBuilder.setSandboxed(false);
        requireBuilder.setModuleScriptProvider(new ModuleScriptProvider(){

            public ModuleScript getModuleScript(Context cx, String moduleId, URI moduleUri, URI baseUri, Scriptable paths) throws Exception {
                Script script = cx.compileString(moduleResource.getContent(), moduleResource.getName(), 1, null);
                return new ModuleScript(script, URI.create(moduleResource.getName()), URI.create(moduleResource.getName()));
            }
        });
        Require require = requireBuilder.createRequire(context, scope);
        return require.requireMain(context, moduleId);
    }

    protected NativeObject callModuleFunction(Context context, Scriptable scope, Scriptable module, String functionName, String[] args) {
        Function function = (Function)module.get(functionName, scope);
        return (NativeObject)function.call(context, scope, module, (Object[])args);
    }

    protected String buildSimpleRunScript(String jsFunction, String content, String ... extraArgs) {
        StringBuilder command = new StringBuilder(jsFunction);
        command.append("(");
        command.append(this.toJSMultiLineString(content));
        if (extraArgs != null) {
            for (String extraArg : extraArgs) {
                command.append(",");
                command.append(extraArg);
            }
        }
        command.append(");");
        return command.toString();
    }

    protected String toJSMultiLineString(String data) {
        StringBuffer result = new StringBuffer("[");
        if (data != null) {
            String[] lines = data.split("\n");
            if (lines.length == 0) {
                result.append("\"\"");
            }
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                result.append("\"");
                result.append(line.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\\r|\\n", ""));
                if (lines.length == 1) {
                    result.append("\\n");
                }
                result.append("\"");
                if (i >= lines.length - 1) continue;
                result.append(",");
            }
        }
        result.append("].join(\"\\n\")");
        return result.toString();
    }
}

