/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.uglify;

import java.io.IOException;
import org.hibnet.webpipes.processor.rhino.RhinoBasedProcessor;
import org.hibnet.webpipes.resource.ClasspathResource;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.ResourceFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class UglifyJsProcessor
extends RhinoBasedProcessor {
    private boolean uglify;
    private String reservedNames;
    private ClasspathResource invokeResource;
    private ClasspathResource defaultOptionsResource;

    public UglifyJsProcessor(boolean uglify, ResourceFactory resourceFactory) {
        super(resourceFactory);
        this.uglify = uglify;
        this.invokeResource = new ClasspathResource("invoke.js", UglifyJsProcessor.class);
        this.defaultOptionsResource = new ClasspathResource("options.js", UglifyJsProcessor.class);
    }

    public void setReservedNames(String reservedNames) {
        this.reservedNames = reservedNames;
    }

    @Override
    protected void initScope(Context context, ScriptableObject globalScope) throws IOException {
        this.evaluateFromClasspath(context, (Scriptable)globalScope, "/org/hibnet/webpipes/processor/uglify/init.js");
        this.evaluateFromClasspath(context, (Scriptable)globalScope, "/org/hibnet/webpipes/processor/uglify/uglifyJs.min.js");
    }

    @Override
    protected String process(Context context, Scriptable scope, Resource resource, String content) throws Exception {
        String optionsAsJson = this.createOptionsAsJson();
        String script = String.format(this.invokeResource.getContent(), this.toJSMultiLineString(content), optionsAsJson);
        return (String)this.evaluate(context, scope, script);
    }

    private String getReservedNames() {
        return this.reservedNames == null ? "" : this.reservedNames;
    }

    protected String createOptionsAsJson() throws IOException {
        return String.format(this.defaultOptionsResource.getContent(), !this.uglify, this.getReservedNames());
    }
}

