/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.StreamResource;

public class ClasspathResource
extends StreamResource {
    private String location;
    private ClassLoader classLoader;
    private Class<?> cls;
    private String protocol;
    private long timestamp;

    public ClasspathResource(String location) {
        this.location = location;
    }

    public ClasspathResource(String location, Class<?> cls) {
        this(location);
        this.cls = cls;
    }

    public ClasspathResource(String location, ClassLoader classLoader) {
        this(location);
        this.classLoader = classLoader;
    }

    @Override
    public String getName() {
        return this.location;
    }

    @Override
    protected InputStream fetchStream() throws IOException {
        URL url = this.getURL();
        this.protocol = url.getProtocol();
        File file = null;
        if ("file".equals(url.getProtocol())) {
            file = new File(url.getPath());
        } else if ("jar".equals(url.getProtocol())) {
            String path = url.getPath();
            file = new File(URI.create(path.substring(0, path.indexOf("!"))));
        } else {
            throw new IllegalStateException("Unsupported classpath url: " + url.toExternalForm());
        }
        this.timestamp = file.lastModified();
        InputStream is = url.openStream();
        if (is == null) {
            throw new IOException("Cannot find the resource '" + this.location + "' in the classpath");
        }
        return is;
    }

    @Override
    public boolean refresh() throws IOException {
        boolean update;
        URL url = this.getURL();
        String newProtocol = url.getProtocol();
        boolean bl = update = newProtocol != this.protocol;
        if (update) {
            this.invalidateCachedContent();
            return true;
        }
        File file = null;
        if ("file".equals(url.getProtocol())) {
            file = new File(url.getPath());
        } else if ("jar".equals(url.getProtocol())) {
            String path = url.getPath();
            file = new File(URI.create(path.substring(0, path.indexOf("!"))));
        } else {
            return false;
        }
        long newJarTimestamp = file.lastModified();
        boolean bl2 = update = newJarTimestamp != this.timestamp;
        if (update) {
            this.invalidateCachedContent();
        }
        return update;
    }

    private URL getURL() throws IOException {
        URL url;
        if (this.classLoader != null) {
            url = this.classLoader.getResource(this.location);
        } else if (this.cls != null) {
            url = this.cls.getResource(this.location);
        } else {
            url = Thread.currentThread().getContextClassLoader().getResource(this.location);
            if (url == null) {
                url = this.getClass().getResource(this.location);
            }
        }
        if (url == null) {
            throw new IOException("Cannot find the resource '" + this.location + "' in the classpath");
        }
        return url;
    }

    @Override
    public Resource resolve(String relativePath) {
        String fullPath = FilenameUtils.getFullPath((String)this.location) + relativePath;
        String normalized = FilenameUtils.normalize((String)fullPath);
        return new ClasspathResource(normalized, this.cls);
    }
}

