/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.StreamResource;

public class FileResource
extends StreamResource {
    private File file;
    private long timestamp;

    public FileResource(String path) {
        this(new File(path));
    }

    public FileResource(File file) {
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    protected InputStream fetchStream() throws IOException {
        this.timestamp = this.file.lastModified();
        return new FileInputStream(this.file);
    }

    @Override
    public boolean refresh() throws IOException {
        boolean update;
        long newJarTimestamp = this.file.lastModified();
        boolean bl = update = newJarTimestamp != this.timestamp;
        if (update) {
            this.invalidateCachedContent();
        }
        return update;
    }

    @Override
    public Resource resolve(String relativePath) {
        String fullPath = FilenameUtils.getFullPath((String)this.file.getAbsolutePath()) + relativePath;
        String normalized = FilenameUtils.normalize((String)fullPath);
        return new FileResource(new File(normalized));
    }
}

