/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.resource;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibnet.webpipes.resource.ClasspathResourceFactory;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.ResourceRefresher;
import org.hibnet.webpipes.resource.TypedResourceFactory;
import org.hibnet.webpipes.resource.WebJarResourceFactory;

public class ResourceFactory {
    private Map<String, TypedResourceFactory> factories = new ConcurrentHashMap<String, TypedResourceFactory>();
    private Map<String, Map<String, Resource>> cache = new ConcurrentHashMap<String, Map<String, Resource>>();
    private ResourceRefresher resourceRefresher = null;

    public ResourceFactory() {
        this(true);
    }

    public ResourceFactory(boolean addDefaults) {
        if (addDefaults) {
            this.addDefaults();
        }
    }

    public void addDefaults() {
        this.register(new WebJarResourceFactory());
        this.register(new ClasspathResourceFactory());
    }

    public void setFactories(Map<String, TypedResourceFactory> factories) {
        this.factories.putAll(factories);
    }

    public void register(TypedResourceFactory factory) {
        this.factories.put(factory.getType(), factory);
    }

    public void setResourceRefresher(ResourceRefresher resourceRefresher) {
        this.resourceRefresher = resourceRefresher;
    }

    public Resource get(String type, String path) {
        Resource resource;
        Map<String, Resource> resources = this.cache.get(type);
        if (resources == null) {
            resources = new ConcurrentHashMap<String, Resource>();
            this.cache.put(path, resources);
        }
        if ((resource = resources.get(path)) == null) {
            TypedResourceFactory factory = this.factories.get(type);
            if (factory == null) {
                throw new IllegalArgumentException("Unknown resource factory type '" + type + "'");
            }
            resource = factory.get(path);
            resources.put(path, resource);
            if (this.resourceRefresher != null) {
                this.resourceRefresher.addResource(resource);
            }
        }
        return resource;
    }
}

