/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hibnet.webpipes.Webpipe;
import org.hibnet.webpipes.resource.Resource;

public class ResourceRefresher {
    private volatile long sleepTime = 1000L;
    private List<Webpipe> webpipes = new CopyOnWriteArrayList<Webpipe>();
    private List<Resource> resources = new CopyOnWriteArrayList<Resource>();
    private volatile boolean sleepTimeChanged = false;
    private volatile boolean interuptable = false;
    private Thread thread;
    private volatile boolean stop = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSleepTime(long sleepTime) {
        ResourceRefresher resourceRefresher = this;
        synchronized (resourceRefresher) {
            this.sleepTime = sleepTime;
            this.sleepTimeChanged = true;
            if (this.thread != null && this.interuptable) {
                this.thread.interrupt();
            }
        }
    }

    public void setWebpipes(Collection<? extends Webpipe> webpipes) {
        this.webpipes = new CopyOnWriteArrayList<Webpipe>(webpipes);
    }

    public void addWebpipe(Webpipe webpipe) {
        this.webpipes.add(webpipe);
    }

    public void removeWebpipe(Webpipe webpipe) {
        this.webpipes.remove(webpipe);
    }

    public void setResources(Collection<? extends Resource> resources) {
        this.resources = new CopyOnWriteArrayList<Resource>(resources);
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public void removeResource(Resource resource) {
        this.resources.remove(resource);
    }

    public synchronized void startWatcher() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean quit;
                do {
                    try {
                        ResourceRefresher.this.refreshAll();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } while (!(quit = this.sleep()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            private boolean sleep() {
                block18: {
                    var1_1 = ResourceRefresher.this;
                    synchronized (var1_1) {
                        if (ResourceRefresher.access$000(ResourceRefresher.this)) {
                            ResourceRefresher.access$002(ResourceRefresher.this, false);
                            return true;
                        }
                    }
                    time = System.currentTimeMillis();
                    sleep = ResourceRefresher.access$100(ResourceRefresher.this);
                    ResourceRefresher.access$202(ResourceRefresher.this, true);
                    while (true) {
                        if (sleep <= 0L) break block18;
                        try {
                            Thread.sleep(sleep);
                            var5_6 = false;
                            return var5_6;
                        }
                        catch (InterruptedException e) {
                            var6_7 = ResourceRefresher.this;
                            synchronized (var6_7) {
                                if (ResourceRefresher.access$300(ResourceRefresher.this)) {
                                    sleep = ResourceRefresher.access$100(ResourceRefresher.this) - (time - System.currentTimeMillis());
                                    ResourceRefresher.access$302(ResourceRefresher.this, false);
                                    ** break block19
                                }
                                if (!ResourceRefresher.access$000(ResourceRefresher.this)) ** break block20
                                ResourceRefresher.access$002(ResourceRefresher.this, false);
                                var7_8 = true;
                            }
                            ResourceRefresher.access$202(ResourceRefresher.this, false);
                            return var7_8;
                            {
                                var7_9 = true;
                            }
                            ResourceRefresher.access$202(ResourceRefresher.this, false);
                            return var7_9;
lbl-1000:
                            // 1 sources

                            {
                                // MONITOREXIT @DISABLED, blocks:[1, 6, 7, 9, 11, 15] lbl51 : MonitorExitStatement: MONITOREXIT : var6_7
                                continue;
                                {
                                    catch (Throwable var8_10) {
                                        throw var8_10;
                                    }
                                }
                            }
                        }
                        break;
                    }
                    finally {
                        ResourceRefresher.access$202(ResourceRefresher.this, false);
                    }
                }
                return false;
            }
        });
        this.thread.setName("WRO Resource Refresher");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void stopWatcher() {
        if (this.thread == null) {
            return;
        }
        this.stop = true;
        if (this.interuptable) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    public void refreshAll() throws IOException {
        ArrayList<Webpipe> webpipesToRefresh = new ArrayList<Webpipe>();
        HashMap<Resource, Boolean> changedResources = new HashMap<Resource, Boolean>();
        for (Resource resource : this.resources) {
            Boolean changedResource = (Boolean)changedResources.get(resource);
            if (changedResource != null) continue;
            changedResource = resource.refresh();
            changedResources.put(resource, changedResource);
        }
        for (Webpipe webpipe : this.webpipes) {
            Resource r;
            boolean changed = false;
            Iterator<Resource> i$ = webpipe.getResources().iterator();
            while (i$.hasNext() && !(changed = ((Boolean)changedResources.get(r = i$.next())).booleanValue())) {
            }
            if (!changed) continue;
            webpipe.invalidateCachedContent();
            webpipesToRefresh.add(webpipe);
        }
        for (Map.Entry entry : changedResources.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            ((Resource)entry.getKey()).getContent();
        }
        for (Webpipe webpipe : webpipesToRefresh) {
            webpipe.getContents();
        }
    }

    static /* synthetic */ boolean access$000(ResourceRefresher x0) {
        return x0.stop;
    }

    static /* synthetic */ boolean access$002(ResourceRefresher x0, boolean x1) {
        x0.stop = x1;
        return x0.stop;
    }

    static /* synthetic */ long access$100(ResourceRefresher x0) {
        return x0.sleepTime;
    }

    static /* synthetic */ boolean access$202(ResourceRefresher x0, boolean x1) {
        x0.interuptable = x1;
        return x0.interuptable;
    }

    static /* synthetic */ boolean access$300(ResourceRefresher x0) {
        return x0.sleepTimeChanged;
    }

    static /* synthetic */ boolean access$302(ResourceRefresher x0, boolean x1) {
        x0.sleepTimeChanged = x1;
        return x0.sleepTimeChanged;
    }
}

