/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.StreamResource;

public class UrlResource
extends StreamResource {
    private int timeout;
    private URL url;

    public UrlResource(URL url) {
        this.url = url;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public String getName() {
        return this.url.toExternalForm();
    }

    @Override
    public InputStream fetchStream() throws IOException {
        URLConnection connection = this.url.openConnection();
        connection.setUseCaches(false);
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        return new BufferedInputStream(connection.getInputStream());
    }

    @Override
    public boolean refresh() throws IOException {
        return false;
    }

    @Override
    public Resource resolve(String relativePath) throws IOException {
        try {
            return new UrlResource(this.url.toURI().resolve(relativePath).toURL());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

