/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.immersiveui.client.gui.component.widget.component;

import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.hiedacamellia.immersiveui.client.gui.component.widget.component.ComponentWidget;

public class AreaComponentWidget
extends ComponentWidget {
    private double y_offset = 0.0;
    private int textHeight;

    public AreaComponentWidget(int width, int height, Component component) {
        this(0, 0, width, height, component);
    }

    public AreaComponentWidget(int x, int y, int width, int height, Component component) {
        super(x, y, width, height, component);
        Objects.requireNonNull(font);
        this.textHeight = 9 * font.split((FormattedText)component, width).size();
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int yOff = (int)this.y_offset;
        for (FormattedCharSequence charSequence : font.split((FormattedText)this.component, this.width)) {
            if (yOff < 0) continue;
            Objects.requireNonNull(font);
            if (yOff + 9 > this.height) {
                return;
            }
            guiGraphics.drawString(font, charSequence, this.getX(), this.getY() + yOff, this.getColor(), this.shadow);
            Objects.requireNonNull(font);
            yOff += 9;
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isHovered) {
            this.y_offset = this.y_offset + scrollY < 0.0 ? 0.0 : (this.y_offset + scrollY + (double)this.textHeight > (double)this.height ? (double)(this.height - this.textHeight) : (this.y_offset += scrollY));
            return true;
        }
        return false;
    }
}

