/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.dynamic.classloader;

import com.google.auto.service.AutoService;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.hifforce.lattice.spi.classloader.CustomClassLoaderSpi;
import org.hiforce.lattice.dynamic.properties.LatticeDynamicProperties;

@AutoService(value={CustomClassLoaderSpi.class})
public class LatticeDynamicClassLoaderBuilder
implements CustomClassLoaderSpi {
    public ClassLoader getCustomClassLoader() {
        String[] dirs = LatticeDynamicProperties.getInstance().getPluginDirs();
        ArrayList urls = Lists.newArrayList();
        for (String dir : dirs) {
            urls.addAll(this.buildJarURLList(dir));
        }
        URL[] urlArrays = urls.toArray(new URL[0]);
        return new URLClassLoader(urlArrays, LatticeDynamicClassLoaderBuilder.class.getClassLoader());
    }

    private List<URL> buildJarURLList(String dirStr) {
        ArrayList urls = Lists.newArrayList();
        try {
            File dir = new File(dirStr);
            if (!dir.exists() || !dir.isDirectory()) {
                return Lists.newArrayList();
            }
            File[] jars = dir.listFiles(pathname -> pathname.getPath().endsWith(".jar"));
            if (null == jars) {
                return urls;
            }
            for (File file : jars) {
                urls.add(new URL("file:" + file.getPath()));
            }
            return urls;
        }
        catch (Exception ex) {
            return Lists.newArrayList();
        }
    }
}

