/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.dynamic;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.dynamic.classloader.LatticeClassLoader;
import org.hiforce.lattice.dynamic.destroy.BusinessUninstaller;
import org.hiforce.lattice.dynamic.destroy.DestroyResult;
import org.hiforce.lattice.dynamic.destroy.LatticeUninstaller;
import org.hiforce.lattice.dynamic.destroy.ProductUninstaller;
import org.hiforce.lattice.dynamic.installer.BusinessInstaller;
import org.hiforce.lattice.dynamic.installer.InstallResult;
import org.hiforce.lattice.dynamic.installer.LatticeInstaller;
import org.hiforce.lattice.dynamic.installer.ProductInstaller;
import org.hiforce.lattice.dynamic.model.PluginFileInfo;
import org.hiforce.lattice.dynamic.properties.LatticeDynamicProperties;
import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.message.Message;
import org.hiforce.lattice.runtime.Lattice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatticeDynamic {
    private static final Logger log = LoggerFactory.getLogger(LatticeDynamic.class);
    private static LatticeDynamic instance;
    private final Set<PluginFileInfo> currentFiles = Sets.newConcurrentHashSet();

    private LatticeDynamic() {
    }

    public static LatticeDynamic getInstance() {
        if (null == instance) {
            instance = new LatticeDynamic();
        }
        return instance;
    }

    public void init() {
        this.currentFiles.clear();
    }

    private PluginFileInfo copyAndCreatePluginFile(PluginFileInfo source) {
        String firstDir = LatticeDynamicProperties.getInstance().getPluginDirs()[0];
        File destDir = new File(firstDir);
        try {
            FileUtils.delete((File)new File(firstDir + File.separator + source.getFile().getName()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileUtils.copyFileToDirectory((File)source.getFile(), (File)destDir);
            File destFile = new File(firstDir + File.separator + source.getFile().getName());
            if (!destFile.exists()) {
                throw new LatticeRuntimeException("LATTICE-DYNAMIC-0001", new Object[0]);
            }
            return new PluginFileInfo(destFile);
        }
        catch (LatticeRuntimeException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new LatticeRuntimeException((Throwable)e);
        }
    }

    public synchronized void installPlugin(PluginFileInfo originFile) {
        if (null == LatticeDynamicProperties.getInstance().getPluginDirs() || 0 == LatticeDynamicProperties.getInstance().getPluginDirs().length) {
            return;
        }
        PluginFileInfo pluginFile = this.copyAndCreatePluginFile(originFile);
        log.info("Lattice dynamic install plugin: " + pluginFile.getFile().getName());
        ArrayList installers = Lists.newArrayList((Object[])new LatticeInstaller[]{new BusinessInstaller(), new ProductInstaller()});
        try {
            URL[] urls = new URL[]{new URL("file:" + pluginFile.getFile().getPath())};
            try (LatticeClassLoader classLoader = new LatticeClassLoader(urls, LatticeDynamic.class.getClassLoader());){
                InstallResult result = installers.stream().map(p -> p.install(classLoader, pluginFile)).filter(p -> !p.isSuccess()).findFirst().orElse(null);
                if (null != result) {
                    throw new LatticeRuntimeException(Message.of((String)result.getErrCode(), (String)result.getErrText()));
                }
                this.currentFiles.add(pluginFile);
                Lattice.getInstance().reload();
                log.info("....... Lattice plugin " + pluginFile.getFile().getName() + "...installed successfully.");
            }
        }
        catch (LatticeRuntimeException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new LatticeRuntimeException((Throwable)e);
        }
    }

    public synchronized void uninstallPlugin(String id) {
        PluginFileInfo info = this.currentFiles.stream().filter(p -> StringUtils.equals((CharSequence)id, (CharSequence)p.getId())).findFirst().orElse(null);
        if (null == info) {
            return;
        }
        ArrayList uninstallers = Lists.newArrayList((Object[])new LatticeUninstaller[]{new BusinessUninstaller(), new ProductUninstaller()});
        try {
            URL[] urls = new URL[]{new URL("file:" + info.getFile().getPath())};
            try (LatticeClassLoader classLoader = new LatticeClassLoader(urls, LatticeDynamic.class.getClassLoader());){
                DestroyResult result = uninstallers.stream().map(p -> p.uninstall(classLoader, info)).filter(p -> !p.isSuccess()).findFirst().orElse(null);
                if (null != result) {
                    throw new LatticeRuntimeException(Message.of((String)result.getErrCode(), (String)result.getErrText()));
                }
            }
            info.getFile().delete();
            this.currentFiles.remove(info);
        }
        catch (LatticeRuntimeException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new LatticeRuntimeException((Throwable)e);
        }
    }

    public void loadFile(File file) {
        this.currentFiles.add(new PluginFileInfo(file));
    }

    public String getPluginFileInfos() {
        return this.currentFiles.stream().map(p -> p.getFile().getName()).collect(Collectors.joining(","));
    }

    public Set<PluginFileInfo> getCurrentFiles() {
        return this.currentFiles;
    }
}

