/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.dynamic.installer;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hiforce.lattice.dynamic.classloader.LatticeClassLoader;
import org.hiforce.lattice.dynamic.installer.InstallResult;
import org.hiforce.lattice.dynamic.installer.LatticeInstaller;
import org.hiforce.lattice.dynamic.model.PluginFileInfo;
import org.hiforce.lattice.dynamic.utils.DynamicUtils;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.model.business.IProduct;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.ability.register.TemplateRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductInstaller
implements LatticeInstaller {
    private static final Logger log = LoggerFactory.getLogger(ProductInstaller.class);

    @Override
    public InstallResult install(LatticeClassLoader classLoader, PluginFileInfo fileInfo) {
        if (null == fileInfo) {
            return InstallResult.success(null);
        }
        Set productClassSet = Lattice.getServiceProviderClasses((String)IProduct.class.getName(), (ClassLoader)classLoader);
        if (CollectionUtils.isEmpty(productClassSet = productClassSet.stream().filter(p -> DynamicUtils.isPluginDefined(p, fileInfo)).collect(Collectors.toSet()))) {
            return InstallResult.success(null);
        }
        Set classSet = Lattice.getServiceProviderClasses((String)IBusinessExt.class.getName(), (ClassLoader)classLoader);
        if (CollectionUtils.isNotEmpty(classSet = classSet.stream().filter(p -> DynamicUtils.isPluginDefined(p, fileInfo)).collect(Collectors.toSet()))) {
            log.info("Lattice dynamic install realization: " + fileInfo.getFile().getPath());
            List installed = TemplateRegister.getInstance().registerRealizations(classSet);
            log.info("---> realization installed: " + installed.stream().filter(p -> null != p.getBusinessExt()).map(p -> p.getBusinessExt().getClass().getName()).collect(Collectors.joining(",")));
        }
        if (CollectionUtils.isNotEmpty(productClassSet)) {
            log.info("Lattice dynamic install product: " + fileInfo.getFile().getPath());
            productClassSet = productClassSet.stream().filter(p -> DynamicUtils.isPluginDefined(p, fileInfo)).collect(Collectors.toSet());
            List productSpecs = TemplateRegister.getInstance().registerProducts(productClassSet);
            fileInfo.getProductCodes().addAll(productSpecs.stream().map(p -> p.getCode()).collect(Collectors.toSet()));
            log.info("---> product installed: " + productSpecs.stream().map(p -> String.format("[%s]-%s", p.getCode(), p.getName())).collect(Collectors.joining(",")));
        }
        return InstallResult.success(fileInfo);
    }
}

