/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.dynamic;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.dynamic.classloader.LatticeClassLoader;
import org.hiforce.lattice.dynamic.destroy.BusinessUninstaller;
import org.hiforce.lattice.dynamic.destroy.DestroyResult;
import org.hiforce.lattice.dynamic.destroy.LatticeUninstaller;
import org.hiforce.lattice.dynamic.model.PluginFileInfo;
import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.message.Message;

public class LatticeDynamic {
    private static LatticeDynamic instance;
    private final Set<PluginFileInfo> currentFiles = Sets.newHashSet();

    private LatticeDynamic() {
    }

    public static LatticeDynamic getInstance() {
        if (null == instance) {
            instance = new LatticeDynamic();
        }
        return instance;
    }

    public void init() {
        this.currentFiles.clear();
    }

    public void uninstallPlugin(String id) {
        PluginFileInfo info = this.currentFiles.stream().filter(p -> StringUtils.equals((CharSequence)id, (CharSequence)p.getId())).findFirst().orElse(null);
        if (null == info) {
            return;
        }
        ArrayList uninstallers = Lists.newArrayList((Object[])new LatticeUninstaller[]{new BusinessUninstaller()});
        try {
            URL[] urls = new URL[]{new URL("file:" + info.getFile().getPath())};
            try (LatticeClassLoader classLoader = new LatticeClassLoader(urls, LatticeDynamic.class.getClassLoader());){
                DestroyResult result = uninstallers.stream().map(p -> p.uninstall(classLoader, info)).filter(p -> !p.isSuccess()).findFirst().orElse(null);
                if (null != result) {
                    throw new LatticeRuntimeException(Message.of((String)result.getErrCode(), (String)result.getErrText()));
                }
            }
        }
        catch (LatticeRuntimeException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new LatticeRuntimeException((Throwable)e);
        }
    }

    public void loadFile(File file) {
        this.currentFiles.add(new PluginFileInfo(file));
    }

    public String getPluginFileInfos() {
        return this.currentFiles.stream().map(p -> p.getFile().getName()).collect(Collectors.joining(","));
    }
}

