/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.dynamic.destroy;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.annotation.model.BusinessAnnotation;
import org.hiforce.lattice.dynamic.classloader.LatticeClassLoader;
import org.hiforce.lattice.dynamic.destroy.DestroyResult;
import org.hiforce.lattice.dynamic.destroy.LatticeUninstaller;
import org.hiforce.lattice.dynamic.model.PluginFileInfo;
import org.hiforce.lattice.model.business.IBusiness;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.ability.register.TemplateRegister;
import org.hiforce.lattice.runtime.cache.exension.ExtensionInvokeCache;
import org.hiforce.lattice.utils.LatticeAnnotationUtils;

public class BusinessUninstaller
implements LatticeUninstaller {
    @Override
    public DestroyResult uninstall(LatticeClassLoader classLoader, PluginFileInfo fileInfo) {
        Set businessExtClassSet = Lattice.getServiceProviderClasses((String)IBusiness.class.getName(), (ClassLoader)classLoader);
        if (CollectionUtils.isEmpty((Collection)businessExtClassSet)) {
            return DestroyResult.success();
        }
        businessExtClassSet = businessExtClassSet.stream().filter(p -> this.isPluginDefined((Class)p, fileInfo)).collect(Collectors.toSet());
        for (Class businessClass : businessExtClassSet) {
            BusinessAnnotation annotation = LatticeAnnotationUtils.getBusinessAnnotation((Class)businessClass);
            if (null == annotation) continue;
            TemplateRegister.getInstance().getBusinesses().removeIf(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)annotation.getCode()));
            TemplateRegister.getInstance().getRealizations().removeIf(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)annotation.getCode()));
            ExtensionInvokeCache.getInstance().clear();
        }
        return DestroyResult.success();
    }

    private boolean isPluginDefined(Class targetClass, PluginFileInfo fileInfo) {
        String path = targetClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        return StringUtils.equals((CharSequence)path, (CharSequence)fileInfo.getFile().getPath());
    }
}

