/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.dynamic.model;

import java.io.File;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class PluginFileInfo
implements Serializable {
    private static final long serialVersionUID = 6144274272056556714L;
    private static final String[] strHex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private String id;
    private final File file;

    public PluginFileInfo(File file) {
        this.file = file;
        this.buildMD5Value();
    }

    private void buildMD5Value() {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            for (int n : bytes = digest.digest(FileUtils.readFileToByteArray((File)this.file))) {
                int d = n;
                if (d < 0) {
                    d += 256;
                }
                int d1 = d / 16;
                int d2 = d % 16;
                sb.append(strHex[d1]).append(strHex[d2]);
            }
            this.id = sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginFileInfo that = (PluginFileInfo)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public File getFile() {
        return this.file;
    }
}

