/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.dynamic.properties;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicApplicationProperties {
    private static final Logger log = LoggerFactory.getLogger(DynamicApplicationProperties.class);
    private static PropertiesConfiguration propertiesConfiguration = null;

    private static void initProperties() {
        Configurations configurations = new Configurations();
        FileBasedConfigurationBuilder.setDefaultEncoding(PropertiesConfiguration.class, (String)"UTF-8");
        try {
            propertiesConfiguration = configurations.properties(DynamicApplicationProperties.class.getClassLoader().getResource("application.properties"));
        }
        catch (ConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String getValueString(String key) {
        if (propertiesConfiguration == null) {
            DynamicApplicationProperties.initProperties();
        }
        return propertiesConfiguration.getString(key);
    }

    public static int getValueInt(String key) {
        if (propertiesConfiguration == null) {
            DynamicApplicationProperties.initProperties();
        }
        return propertiesConfiguration.getInt(key, 0);
    }

    static {
        DynamicApplicationProperties.initProperties();
    }
}

