/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.dynamic.utils;

import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.runtime.utils.SpringApplicationContextHolder;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringUtils {
    public static void removeBean(String beanName) {
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)SpringApplicationContextHolder.getContext();
        if (!applicationContext.containsBean(beanName)) {
            return;
        }
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        beanFactory.removeBeanDefinition(beanName);
    }

    public static <T> T registerBean(String beanName, Class<T> clazz, Object ... args) {
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)SpringApplicationContextHolder.getContext();
        if (applicationContext.containsBean(beanName)) {
            Object bean = applicationContext.getBean(beanName);
            if (bean.getClass().isAssignableFrom(clazz)) {
                return (T)bean;
            }
            throw new LatticeRuntimeException("LATTICE-DYNAMIC-0002" + beanName, new Object[0]);
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        for (Object arg : args) {
            beanDefinitionBuilder.addConstructorArgValue(arg);
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return (T)applicationContext.getBean(beanName, clazz);
    }
}

