/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.dynamic.destroy;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hiforce.lattice.annotation.model.ProductAnnotation;
import org.hiforce.lattice.dynamic.classloader.LatticeClassLoader;
import org.hiforce.lattice.dynamic.destroy.DestroyResult;
import org.hiforce.lattice.dynamic.destroy.LatticeUninstaller;
import org.hiforce.lattice.dynamic.model.PluginFileInfo;
import org.hiforce.lattice.dynamic.utils.DynamicUtils;
import org.hiforce.lattice.model.business.IProduct;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.utils.LatticeAnnotationUtils;

public class ProductUninstaller
implements LatticeUninstaller {
    @Override
    public DestroyResult uninstall(LatticeClassLoader classLoader, PluginFileInfo fileInfo) {
        Set classSet = Lattice.getServiceProviderClasses((String)IProduct.class.getName(), (ClassLoader)classLoader);
        if (CollectionUtils.isEmpty((Collection)classSet)) {
            return DestroyResult.success();
        }
        classSet = classSet.stream().filter(p -> DynamicUtils.isPluginDefined(p, fileInfo)).collect(Collectors.toSet());
        for (Class productClass : classSet) {
            ProductAnnotation annotation = LatticeAnnotationUtils.getProductAnnotation((Class)productClass);
            if (null == annotation) continue;
            Lattice.getInstance().getRuntimeCache().clearProductCache(annotation.getCode());
        }
        return DestroyResult.success();
    }
}

