/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.dynamic.destroy;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hiforce.lattice.annotation.model.BusinessAnnotation;
import org.hiforce.lattice.dynamic.classloader.LatticeClassLoader;
import org.hiforce.lattice.dynamic.destroy.DestroyResult;
import org.hiforce.lattice.dynamic.destroy.LatticeUninstaller;
import org.hiforce.lattice.dynamic.model.PluginFileInfo;
import org.hiforce.lattice.dynamic.utils.DynamicUtils;
import org.hiforce.lattice.model.business.IBusiness;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.utils.LatticeAnnotationUtils;

public class BusinessUninstaller
implements LatticeUninstaller {
    @Override
    public synchronized DestroyResult uninstall(LatticeClassLoader classLoader, PluginFileInfo fileInfo) {
        Set businessExtClassSet = Lattice.getServiceProviderClasses((String)IBusiness.class.getName(), (ClassLoader)classLoader);
        if (CollectionUtils.isEmpty((Collection)businessExtClassSet)) {
            return DestroyResult.success();
        }
        businessExtClassSet = businessExtClassSet.stream().filter(p -> DynamicUtils.isPluginDefined(p, fileInfo)).collect(Collectors.toSet());
        for (Class businessClass : businessExtClassSet) {
            BusinessAnnotation annotation = LatticeAnnotationUtils.getBusinessAnnotation((Class)businessClass);
            if (null == annotation) continue;
            Lattice.getInstance().getRuntimeCache().clearBusinessCache(annotation.getCode());
        }
        return DestroyResult.success();
    }
}

