/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.tool;

import com.google.auto.service.AutoService;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.model.config.BusinessConfig;
import org.hifforce.lattice.spi.config.BusinessConfigLoadSpi;
import org.hiforce.lattice.tool.JacksonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={BusinessConfigLoadSpi.class})
public class BizConfigResourceLoader
implements BusinessConfigLoadSpi {
    private static final Logger log = LoggerFactory.getLogger(BizConfigResourceLoader.class);
    private ClassLoader classLoader;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int getPriority() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BusinessConfig> loadBusinessConfigs(List<String> bizCodes) {
        ArrayList configs = Lists.newArrayList();
        for (String bizCode : bizCodes) {
            InputStream is = null;
            try {
                String resourceFile = String.format("lattice/lattice-%s.json", bizCode);
                is = Optional.ofNullable(this.classLoader).orElse(Thread.currentThread().getContextClassLoader()).getResourceAsStream(resourceFile);
                String jsonStr = BizConfigResourceLoader.getStringByInputStream(is);
                if (StringUtils.isEmpty((CharSequence)jsonStr)) continue;
                log.warn("Lattice business [{}] local config file: {} found!", (Object)bizCode, (Object)resourceFile);
                BusinessConfig businessConfig = JacksonUtils.deserializeIgnoreException(jsonStr, BusinessConfig.class);
                configs.add(businessConfig);
                log.warn("Lattice business [{}] local config loaded!", (Object)bizCode);
            }
            finally {
                try {
                    if (null == is) continue;
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return configs;
    }

    public static String getStringByInputStream(InputStream inputStream) {
        if (null == inputStream) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                result.append(line);
            }
            return result.toString();
        }
        catch (Exception e) {
            try {
                inputStream.close();
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

