/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.maven;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.hiforce.lattice.maven.builder.AbilityInfoBuilder;
import org.hiforce.lattice.maven.builder.BusinessInfoBuilder;
import org.hiforce.lattice.maven.builder.LatticeInfoBuilder;
import org.hiforce.lattice.maven.builder.ProductInfoBuilder;
import org.hiforce.lattice.maven.builder.RealizationInfoBuilder;
import org.hiforce.lattice.maven.builder.UseCaseInfoBuilder;
import org.hiforce.lattice.maven.model.LatticeInfo;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.utils.JacksonUtils;

@Mojo(name="lattice", requiresDependencyResolution=ResolutionScope.COMPILE)
public class LatticeBuildPlugin
extends AbstractMojo {
    private final LatticeInfo latticeInfo = new LatticeInfo();
    private static final String LATTICE_DIR = "META-INF" + File.separator + "lattice";
    private static final String LATTICE_FILE = LATTICE_DIR + File.separator + "lattice.json";
    @Parameter(defaultValue="${project}")
    public MavenProject mavenProject;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected String outputDirectory;
    private ClassLoader totalClassLoader;
    private ClassLoader projectClassLoader;
    private ClassLoader importClassLoader;

    public synchronized void execute() throws MojoExecutionException, MojoFailureException {
        Lattice.getInstance().clear();
        this.getLog().info((CharSequence)">> LatticeBuildPlugin start....");
        this.getLog().info((CharSequence)(">> Project: " + this.mavenProject.getName()));
        this.latticeInfo.setGroupId(this.mavenProject.getGroupId());
        this.latticeInfo.setArtifactId(this.mavenProject.getArtifactId());
        this.latticeInfo.setVersion(this.mavenProject.getVersion());
        this.totalClassLoader = this.loadClassLoader(false, false);
        this.projectClassLoader = this.loadClassLoader(true, false);
        this.importClassLoader = this.loadClassLoader(false, true);
        ArrayList builders = Lists.newArrayList((Object[])new LatticeInfoBuilder[]{new RealizationInfoBuilder(this), new AbilityInfoBuilder(this), new ProductInfoBuilder(this), new UseCaseInfoBuilder(this), new BusinessInfoBuilder(this)});
        builders.forEach(LatticeInfoBuilder::build);
        this.writeLatticeInfo();
    }

    private void writeLatticeInfo() throws MojoExecutionException {
        String fullFileDir = this.outputDirectory + File.separator + LATTICE_DIR;
        String fullFilePath = this.outputDirectory + File.separator + LATTICE_FILE;
        OutputStreamWriter oStreamWriter = null;
        try {
            File resourceFile = new File(fullFilePath);
            if (resourceFile.exists()) {
                resourceFile.delete();
            } else {
                File tmp = new File(fullFileDir);
                tmp.mkdirs();
                resourceFile.createNewFile();
            }
            oStreamWriter = new OutputStreamWriter(Files.newOutputStream(resourceFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            oStreamWriter.append(JacksonUtils.serializeWithoutException((Object)this.getLatticeInfo()));
            oStreamWriter.flush();
        }
        catch (IOException e) {
            throw new MojoExecutionException(">> Lattice maven plugin write file failed: " + fullFilePath, (Exception)e);
        }
        finally {
            if (oStreamWriter != null) {
                try {
                    oStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ClassLoader loadClassLoader(boolean onlyProject, boolean onlyImport) {
        ClassLoader originClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            List classPath = this.mavenProject.getCompileClasspathElements();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String cls : classPath) {
                try {
                    if (onlyProject && cls.endsWith(".jar") || onlyImport && (cls.endsWith("classes") || cls.endsWith("classes" + File.separator))) continue;
                    if (!cls.endsWith(".jar") && !cls.endsWith(File.separator)) {
                        cls = cls + File.separator;
                    }
                    urls.add(new URL("file:" + cls));
                }
                catch (MalformedURLException e) {
                    this.getLog().info((CharSequence)e.getMessage());
                }
            }
            URL[] urlArrays = urls.toArray(new URL[urls.size()]);
            return new URLClassLoader(urlArrays, originClassLoader);
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)ex.getMessage());
            return originClassLoader;
        }
    }

    public LatticeInfo getLatticeInfo() {
        return this.latticeInfo;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public ClassLoader getTotalClassLoader() {
        return this.totalClassLoader;
    }

    public ClassLoader getProjectClassLoader() {
        return this.projectClassLoader;
    }

    public ClassLoader getImportClassLoader() {
        return this.importClassLoader;
    }
}

