/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.maven.builder;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hiforce.lattice.maven.LatticeBuildPlugin;
import org.hiforce.lattice.maven.builder.AbilityInfoBuilder;
import org.hiforce.lattice.maven.builder.LatticeInfoBuilder;
import org.hiforce.lattice.maven.model.RealizationInfo;
import org.hiforce.lattice.maven.model.UseCaseInfo;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.model.business.IUseCase;
import org.hiforce.lattice.model.register.UseCaseSpec;
import org.hiforce.lattice.runtime.ability.register.AbilityRegister;
import org.hiforce.lattice.runtime.ability.register.TemplateRegister;

public class UseCaseInfoBuilder
extends LatticeInfoBuilder {
    @Override
    public String getSpiClassName() {
        return IUseCase.class.getName();
    }

    public UseCaseInfoBuilder(LatticeBuildPlugin plugin) {
        super(plugin);
    }

    @Override
    public void build() {
        this.getLog().info((CharSequence)">> Lattice UseCaseInfoBuilder build~~~");
        List<String> providedClassNames = this.getProvidedInfoClassNames();
        List<UseCaseInfo> provided = this.getUseCaseInfo(providedClassNames);
        this.getPlugin().getLatticeInfo().getUseCase().getProviding().addAll(provided);
        TemplateRegister.getInstance().getUseCases().clear();
        List<String> importClassNames = this.getImportInfoClassNames();
        List<UseCaseInfo> imported = this.getUseCaseInfo(importClassNames);
        this.getPlugin().getLatticeInfo().getUseCase().getUsing().addAll(imported);
    }

    private List<UseCaseInfo> getUseCaseInfo(List<String> classNames) {
        try {
            AbilityRegister register = AbilityRegister.getInstance();
            List specs = TemplateRegister.getInstance().registerUseCases(this.loadTargetClassList(classNames));
            return specs.stream().map(p -> this.buildUseCaseInfo((UseCaseSpec)p)).collect(Collectors.toList());
        }
        catch (Throwable th) {
            th.printStackTrace();
            return Lists.newArrayList();
        }
    }

    private UseCaseInfo buildUseCaseInfo(UseCaseSpec useCaseSpec) {
        UseCaseInfo info = new UseCaseInfo();
        List dependencies = this.getPlugin().getMavenProject().getRuntimeDependencies();
        info.setCode(useCaseSpec.getCode());
        info.setName(useCaseSpec.getName());
        info.setClassName(useCaseSpec.getUseCaseClass().getName());
        info.setSdk(useCaseSpec.getSdk().getName());
        info.getExtensions().addAll(useCaseSpec.getExtensions().stream().map(AbilityInfoBuilder::buildExtensionInfo).collect(Collectors.toSet()));
        List realizationInfos = useCaseSpec.getRealizations().stream().map(LatticeInfoBuilder::buildRealizationInfo).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            for (RealizationInfo realizationInfo : realizationInfos) {
                IBusinessExt businessExt = (IBusinessExt)this.getTotalClassLoader().loadClass(realizationInfo.getBusinessExtClass()).newInstance();
                info.getCustomized().addAll(this.buildCustomizedExtensionInfos(businessExt));
            }
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)ex.getMessage(), (Throwable)ex);
        }
        info.setDependency(this.getDependencyInfo(useCaseSpec.getUseCaseClass()));
        return info;
    }
}

