/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.maven.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.hiforce.lattice.annotation.Schema;
import org.hiforce.lattice.annotation.model.ExtensionAnnotation;
import org.hiforce.lattice.jar.LatticeJarUtils;
import org.hiforce.lattice.jar.model.LatticeJarInfo;
import org.hiforce.lattice.maven.LatticeBuildPlugin;
import org.hiforce.lattice.maven.builder.BusinessInfoBuilder;
import org.hiforce.lattice.maven.model.DependencyInfo;
import org.hiforce.lattice.maven.model.ExtensionInfo;
import org.hiforce.lattice.maven.model.RealizationInfo;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.model.register.RealizationSpec;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.utils.LatticeAnnotationUtils;

public abstract class LatticeInfoBuilder {
    private final LatticeBuildPlugin plugin;
    private final ClassLoader totalClassLoader;
    private final ClassLoader importClassLoader;
    private final ClassLoader projectClassLoader;

    public abstract String getSpiClassName();

    public List<String> getProvidedInfoClassNames() {
        return Lattice.getServiceProviderValues((String)this.getSpiClassName(), (ClassLoader)this.getProjectClassLoader());
    }

    public List<String> getImportInfoClassNames() {
        return Lattice.getServiceProviderValues((String)this.getSpiClassName(), (ClassLoader)this.getImportClassLoader());
    }

    public LatticeInfoBuilder(LatticeBuildPlugin plugin) {
        this.plugin = plugin;
        this.projectClassLoader = plugin.getProjectClassLoader();
        this.totalClassLoader = plugin.getTotalClassLoader();
        this.importClassLoader = plugin.getImportClassLoader();
    }

    public abstract void build();

    protected Set<Class> loadTargetClassList(List<String> classNames) {
        HashSet classList = Sets.newHashSet();
        for (String name : classNames) {
            try {
                Class<?> abilityClass = this.getTotalClassLoader().loadClass(name);
                classList.add(abilityClass);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return classList;
    }

    public Log getLog() {
        return this.getPlugin().getLog();
    }

    public static RealizationInfo buildRealizationInfo(RealizationSpec spec) {
        if (null == spec) {
            return null;
        }
        RealizationInfo info = new RealizationInfo();
        info.setScenario(spec.getScenario());
        info.setBusinessExtClass(spec.getBusinessExtClass().getName());
        info.getExtensionCodes().addAll(spec.getExtensionCodes());
        return info;
    }

    public static LatticeJarInfo getSdkLatticeJarInfo(boolean findSuperClass, Class<?> facadeClass) {
        Schema schema = facadeClass.getDeclaredAnnotation(Schema.class);
        if (null != schema) {
            return LatticeInfoBuilder.getPath(facadeClass);
        }
        if (!findSuperClass) {
            return LatticeInfoBuilder.getPath(facadeClass);
        }
        for (Class<?> superClass = facadeClass.getSuperclass(); null != superClass; superClass = superClass.getSuperclass()) {
            schema = superClass.getDeclaredAnnotation(Schema.class);
            if (null != schema && schema.root()) {
                return LatticeInfoBuilder.getPath(superClass);
            }
            if (!Object.class.equals(superClass.getSuperclass())) continue;
            return LatticeInfoBuilder.getPath(superClass);
        }
        return null;
    }

    public static LatticeJarInfo getPath(Class<?> targetClass) {
        String path = targetClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            File file = new File(path);
            return LatticeJarUtils.parseLatticeJar((String)file.getName(), (InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DependencyInfo getDependencyInfo(Class<?> targetClass) {
        if (null == targetClass) {
            return null;
        }
        try {
            String path;
            ProtectionDomain protectionDomain = targetClass.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URI location = codeSource != null ? codeSource.getLocation().toURI() : null;
            String string = path = location != null ? location.getSchemeSpecificPart() : null;
            if (null == path) {
                return null;
            }
            File file = new File(path);
            List dependencies = this.getPlugin().getMavenProject().getRuntimeDependencies();
            return dependencies.stream().filter(p -> StringUtils.equals((CharSequence)file.getName(), (CharSequence)String.format("%s-%s.jar", p.getArtifactId(), p.getVersion()))).findFirst().map(p -> DependencyInfo.of((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion())).orElse(null);
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public List<ExtensionInfo> buildCustomizedExtensionInfos(IBusinessExt businessExt) {
        ArrayList extensionInfos = Lists.newArrayList();
        for (Method method : businessExt.getClass().getMethods()) {
            Class<?> businessExtClass;
            Schema schema;
            ExtensionAnnotation annotation = LatticeAnnotationUtils.getExtensionAnnotation((Method)method);
            if (null == annotation || null != (schema = (businessExtClass = method.getDeclaringClass()).getDeclaredAnnotation(Schema.class)) && schema.root()) continue;
            ExtensionInfo extensionInfo = BusinessInfoBuilder.buildExtensionInfo(businessExt.getClass(), annotation, method);
            extensionInfos.add(extensionInfo);
        }
        for (IBusinessExt subBusinessExt : businessExt.getAllSubBusinessExt()) {
            extensionInfos.addAll(this.buildCustomizedExtensionInfos(subBusinessExt));
        }
        return extensionInfos;
    }

    public LatticeBuildPlugin getPlugin() {
        return this.plugin;
    }

    public ClassLoader getTotalClassLoader() {
        return this.totalClassLoader;
    }

    public ClassLoader getImportClassLoader() {
        return this.importClassLoader;
    }

    public ClassLoader getProjectClassLoader() {
        return this.projectClassLoader;
    }
}

