/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.maven.builder;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.business.IProduct;
import org.hifforce.lattice.model.register.ProductSpec;
import org.hiforce.lattice.maven.LatticeBuildPlugin;
import org.hiforce.lattice.maven.builder.LatticeInfoBuilder;
import org.hiforce.lattice.maven.model.DependencyInfo;
import org.hiforce.lattice.maven.model.ProductInfo;
import org.hiforce.lattice.maven.model.RealizationInfo;
import org.hiforce.lattice.runtime.ability.register.TemplateRegister;

public class ProductInfoBuilder
extends LatticeInfoBuilder {
    public ProductInfoBuilder(LatticeBuildPlugin plugin) {
        super(plugin);
    }

    @Override
    public String getSpiClassName() {
        return IProduct.class.getName();
    }

    @Override
    public void build() {
        List<ProductInfo> provided = this.getProductInfo(this.getProvidedInfoClassNames());
        this.getPlugin().getLatticeInfo().getProduct().getProviding().addAll(provided);
        TemplateRegister.getInstance().getProducts().clear();
        List<ProductInfo> imported = this.getProductInfo(this.getImportInfoClassNames());
        this.getPlugin().getLatticeInfo().getProduct().getUsing().addAll(imported);
    }

    private List<ProductInfo> getProductInfo(List<String> classNames) {
        try {
            List specs = TemplateRegister.getInstance().registerProducts(this.loadTargetClassList(classNames));
            return specs.stream().map(p -> this.buildProductInfo((ProductSpec)p)).collect(Collectors.toList());
        }
        catch (Throwable th) {
            th.printStackTrace();
            return Lists.newArrayList();
        }
    }

    private ProductInfo buildProductInfo(ProductSpec spec) {
        ProductInfo info = new ProductInfo();
        List dependencies = this.getPlugin().getMavenProject().getRuntimeDependencies();
        info.setCode(spec.getCode());
        info.setName(spec.getName());
        info.setClassName(spec.getProductClass().getName());
        List realizationInfos = spec.getRealizations().stream().map(LatticeInfoBuilder::buildRealizationInfo).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            for (RealizationInfo realizationInfo : realizationInfos) {
                IBusinessExt businessExt = (IBusinessExt)this.getTotalClassLoader().loadClass(realizationInfo.getBusinessExtClass()).newInstance();
                info.getCustomized().addAll(this.buildCustomizedExtensionInfos(businessExt));
            }
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)ex.getMessage(), (Throwable)ex);
        }
        try {
            ProtectionDomain protectionDomain = spec.getProductClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URI location = codeSource != null ? codeSource.getLocation().toURI() : null;
            String path = location != null ? location.getSchemeSpecificPart() : null;
            File file = new File(path);
            DependencyInfo dependency = dependencies.stream().filter(p -> StringUtils.equals((CharSequence)file.getName(), (CharSequence)String.format("%s-%s.jar", p.getArtifactId(), p.getVersion()))).findFirst().map(p -> DependencyInfo.of((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion())).orElse(null);
            if (null != dependency) {
                info.setDependency(dependency);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return info;
    }
}

