/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.maven.builder;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.business.IUseCase;
import org.hifforce.lattice.model.register.UseCaseSpec;
import org.hiforce.lattice.maven.LatticeBuildPlugin;
import org.hiforce.lattice.maven.builder.AbilityInfoBuilder;
import org.hiforce.lattice.maven.builder.LatticeInfoBuilder;
import org.hiforce.lattice.maven.model.DependencyInfo;
import org.hiforce.lattice.maven.model.RealizationInfo;
import org.hiforce.lattice.maven.model.UseCaseInfo;
import org.hiforce.lattice.runtime.ability.register.AbilityRegister;
import org.hiforce.lattice.runtime.ability.register.TemplateRegister;

public class UseCaseInfoBuilder
extends LatticeInfoBuilder {
    @Override
    public String getSpiClassName() {
        return IUseCase.class.getName();
    }

    public UseCaseInfoBuilder(LatticeBuildPlugin plugin) {
        super(plugin);
    }

    @Override
    public void build() {
        this.getLog().info((CharSequence)">> Lattice UseCaseInfoBuilder build~~~");
        List<String> providedClassNames = this.getProvidedInfoClassNames();
        List<UseCaseInfo> provided = this.getUseCaseInfo(providedClassNames);
        this.getPlugin().getLatticeInfo().getUseCase().getProviding().addAll(provided);
        TemplateRegister.getInstance().getUseCases().clear();
        List<String> importClassNames = this.getImportInfoClassNames();
        List<UseCaseInfo> imported = this.getUseCaseInfo(importClassNames);
        this.getPlugin().getLatticeInfo().getUseCase().getUsing().addAll(imported);
    }

    private List<UseCaseInfo> getUseCaseInfo(List<String> classNames) {
        try {
            AbilityRegister register = AbilityRegister.getInstance();
            List specs = TemplateRegister.getInstance().registerUseCases(this.loadTargetClassList(classNames));
            return specs.stream().map(p -> this.buildUseCaseInfo((UseCaseSpec)p)).collect(Collectors.toList());
        }
        catch (Throwable th) {
            th.printStackTrace();
            return Lists.newArrayList();
        }
    }

    private UseCaseInfo buildUseCaseInfo(UseCaseSpec useCaseSpec) {
        UseCaseInfo info = new UseCaseInfo();
        List dependencies = this.getPlugin().getMavenProject().getRuntimeDependencies();
        info.setCode(useCaseSpec.getCode());
        info.setName(useCaseSpec.getName());
        info.setClassName(useCaseSpec.getUseCaseClass().getName());
        info.setSdk(useCaseSpec.getSdk().getName());
        info.getExtensions().addAll(useCaseSpec.getExtensions().stream().map(AbilityInfoBuilder::buildExtensionInfo).collect(Collectors.toSet()));
        List realizationInfos = useCaseSpec.getRealizations().stream().map(LatticeInfoBuilder::buildRealizationInfo).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            for (RealizationInfo realizationInfo : realizationInfos) {
                IBusinessExt businessExt = (IBusinessExt)this.getTotalClassLoader().loadClass(realizationInfo.getBusinessExtClass()).newInstance();
                info.getCustomized().addAll(this.buildCustomizedExtensionInfos(businessExt));
            }
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)ex.getMessage(), (Throwable)ex);
        }
        try {
            ProtectionDomain protectionDomain = useCaseSpec.getUseCaseClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URI location = codeSource != null ? codeSource.getLocation().toURI() : null;
            String path = location != null ? location.getSchemeSpecificPart() : null;
            File file = new File(path);
            DependencyInfo dependency = dependencies.stream().filter(p -> StringUtils.equals((CharSequence)file.getName(), (CharSequence)String.format("%s-%s.jar", p.getArtifactId(), p.getVersion()))).findFirst().map(p -> DependencyInfo.of((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion())).orElse(null);
            if (null != dependency) {
                info.setDependency(dependency);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return info;
    }
}

