/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.remote.client.properties;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="latticeRemoteClientProperties")
public class LatticeRemoteClientProperties
implements InitializingBean {
    private static LatticeRemoteClientProperties instance;
    private String registryAddress;
    @Autowired
    private Environment environment;

    private LatticeRemoteClientProperties() {
    }

    public void afterPropertiesSet() throws Exception {
        String value;
        instance = this;
        this.registryAddress = this.environment.getProperty("lattice.remote.registry.address");
        if (StringUtils.isEmpty((CharSequence)this.registryAddress)) {
            this.registryAddress = this.environment.getProperty("dubbo.registry.address");
        }
        if (StringUtils.isEmpty((CharSequence)this.registryAddress) && StringUtils.isNotEmpty((CharSequence)(value = this.environment.getProperty("spring.cloud.nacos.config.server-addr")))) {
            this.registryAddress = "nacos://" + value;
        }
    }

    public static LatticeRemoteClientProperties getInstance() {
        return instance;
    }

    public String getRegistryAddress() {
        return this.registryAddress;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }
}

