/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.remote.client;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.hiforce.lattice.remote.client.model.RemoteBusiness;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class LatticeRemoteClient
implements InitializingBean {
    private final List<RemoteBusiness> supportRemoteBusinessList = Lists.newArrayList();
    private static LatticeRemoteClient instance;

    private LatticeRemoteClient() {
    }

    public void registerRemoteBusiness(RemoteBusiness ... businesses) {
        if (null == businesses) {
            return;
        }
        this.supportRemoteBusinessList.addAll(Arrays.asList(businesses));
    }

    public void afterPropertiesSet() throws Exception {
        instance = this;
    }

    public List<RemoteBusiness> getSupportRemoteBusinessList() {
        return this.supportRemoteBusinessList;
    }

    public static LatticeRemoteClient getInstance() {
        return instance;
    }
}

