/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.remote.client.properties;

import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.remote.client.properties.ApplicationProperties;
import org.hiforce.lattice.remote.client.properties.BootstrapProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service(value="latticeRemoteClientProperties")
public class LatticeRemoteClientProperties
implements InitializingBean {
    private static LatticeRemoteClientProperties instance;
    private String registryAddress;

    private LatticeRemoteClientProperties() {
    }

    public void afterPropertiesSet() throws Exception {
        String value;
        instance = this;
        this.registryAddress = ApplicationProperties.getValueString("lattice.remote.registry.address");
        if (StringUtils.isEmpty((CharSequence)this.registryAddress)) {
            this.registryAddress = ApplicationProperties.getValueString("dubbo.registry.address");
        }
        if (StringUtils.isEmpty((CharSequence)this.registryAddress) && StringUtils.isNotEmpty((CharSequence)(value = ApplicationProperties.getValueString("spring.cloud.nacos.config.server-addr")))) {
            this.registryAddress = "nacos://" + value;
        }
        if (StringUtils.isEmpty((CharSequence)this.registryAddress) && StringUtils.isNotEmpty((CharSequence)(value = BootstrapProperties.getValueString("spring.cloud.nacos.config.server-addr")))) {
            this.registryAddress = "nacos://" + value;
        }
    }

    public static LatticeRemoteClientProperties getInstance() {
        return instance;
    }

    public String getRegistryAddress() {
        return this.registryAddress;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }
}

