/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.remote.container.service;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.model.register.RealizationSpec;
import org.hiforce.lattice.remote.client.LatticeRemoteInvoker;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.utils.BusinessExtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatticeRemoteInvokerImpl
implements LatticeRemoteInvoker {
    private static final Logger log = LoggerFactory.getLogger(LatticeRemoteInvokerImpl.class);

    public Serializable invoke(String bizCode, String scenario, String extCode, Object ... params) {
        log.info("[Lattice]Remote Invoked, bizCode={}, scenario={}, extCode={} ", new Object[]{bizCode, scenario, extCode});
        RealizationSpec realizationSpec = Lattice.getInstance().getAllRealizations().stream().filter(p -> StringUtils.equals((CharSequence)bizCode, (CharSequence)p.getCode())).filter(p -> this.isScenarioMatched(scenario, p.getScenario())).filter(p -> p.getExtensionCodes().contains(extCode)).findFirst().orElse(null);
        if (null == realizationSpec) {
            log.warn("[Lattice] The realization not found. bizCode={}, scenario={}, extCode={} ", new Object[]{bizCode, scenario, extCode});
            return null;
        }
        try {
            IBusinessExt businessExt = realizationSpec.getBusinessExt().getBusinessExtByCode(extCode, scenario);
            log.debug("[Lattice] The BusinessExt={}, bizCode={}, scenario={}, extCode={}", new Object[]{businessExt, bizCode, scenario, extCode});
            Method method = BusinessExtUtils.getExtensionMethod((IBusinessExt)businessExt, (String)extCode, (String)scenario);
            Serializable value = (Serializable)method.invoke((Object)businessExt, params);
            log.debug("[Lattice] Remote invoke bizCode={}, scenario={}, extCode={}, result={}", new Object[]{bizCode, scenario, extCode, null == value ? null : value.toString()});
            return value;
        }
        catch (Exception e) {
            log.info("[Lattice] Remote invoke runtime exception occurred. ex=bizCode={}, scenario={}, extCode={}, ex={}", new Object[]{bizCode, scenario, extCode, e.getMessage()});
            throw new RuntimeException(e);
        }
    }

    private boolean isScenarioMatched(String targetScenario, String specScenario) {
        if (StringUtils.isEmpty((CharSequence)targetScenario) && StringUtils.isEmpty((CharSequence)specScenario)) {
            return true;
        }
        if (null == targetScenario || null == specScenario) {
            return false;
        }
        return StringUtils.equals((CharSequence)targetScenario, (CharSequence)specScenario);
    }
}

