/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.remote.container;

import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.hifforce.lattice.model.register.BusinessSpec;
import org.hiforce.lattice.remote.client.LatticeRemoteInvoker;
import org.hiforce.lattice.remote.container.service.LatticeRemoteInvokerImpl;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.ability.register.TemplateRegister;

public class LatticePluginContainer {
    private static LatticePluginContainer instance;

    private LatticePluginContainer() {
    }

    public static LatticePluginContainer getInstance() {
        if (null == instance) {
            instance = new LatticePluginContainer();
        }
        return instance;
    }

    public void start() {
        Lattice.getInstance().start();
        ApplicationConfig application = new ApplicationConfig();
        application.setName("lattice-remote-container");
        application.setId("lattice-remote-container");
        MonitorConfig monitorConfig = new MonitorConfig();
        monitorConfig.setProtocol("dubbo-registry");
        application.setMonitor(monitorConfig);
        ProtocolConfig protocol = new ProtocolConfig();
        protocol.setName("dubbo");
        protocol.setPort(Integer.valueOf(-1));
        protocol.setThreads(Integer.valueOf(200));
        RegistryConfig registry = new RegistryConfig();
        registry.setAddress("nacos://172.18.70.228:8848");
        registry.getMetaData().put("report.address", "nacos://172.18.70.228:8848");
        for (BusinessSpec businessSpec : TemplateRegister.getInstance().getBusinesses()) {
            ServiceConfig service = new ServiceConfig();
            service.setApplication(application);
            service.setRegistry(registry);
            service.setProtocol(protocol);
            service.setInterface(LatticeRemoteInvoker.class);
            service.setRef((Object)new LatticeRemoteInvokerImpl());
            service.setVersion("1.0.0");
            service.setGroup(String.format("lattice-%s", businessSpec.getCode()));
            service.export();
        }
    }
}

