/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.remote.runner;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.hifforce.lattice.exception.LatticeRuntimeException;
import org.hifforce.lattice.extension.ExtensionRemoteRunner;
import org.hifforce.lattice.extension.ExtensionRunner;
import org.hifforce.lattice.extension.ExtensionRunnerType;
import org.hifforce.lattice.model.ability.IAbility;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.ability.execute.ExtensionCallback;
import org.hifforce.lattice.model.business.IBizObject;
import org.hifforce.lattice.model.register.TemplateSpec;
import org.hiforce.lattice.remote.client.LatticeRemoteInvoker;
import org.hiforce.lattice.remote.runner.init.LatticeDubboRunnerEnv;
import org.hiforce.lattice.remote.runner.key.DubboInvokeCacheKey;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboExtensionRunner<R>
extends ExtensionRemoteRunner<R> {
    private static final Logger log = LoggerFactory.getLogger(DubboExtensionRunner.class);
    private static Map<DubboInvokeCacheKey, LatticeRemoteInvoker> INVOKE_CACHE = Maps.newHashMap();
    private IAbility ability;
    private TemplateSpec template;
    private String scenario;

    public DubboExtensionRunner(String extensionCode) {
        super(extensionCode);
    }

    public Object runFirstMatched(IBizObject bizObject, ExtensionCallback callback, ExtensionRunner.RunnerExecuteResult executeResult) {
        IBusinessExt businessExt = this.ability.getDefaultRealization();
        List extParams = this.ability.getContext().getInvokeParams();
        executeResult.setRunnerType(this.getType());
        try {
            Object object = this.invoke(extParams);
            return object;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new LatticeRuntimeException("LATTICE-RMI-DUBBO-0001", new Object[]{ex.getMessage()});
        }
        finally {
            executeResult.setExecute(true);
        }
    }

    private Object invoke(List<Object> params) {
        String scenario;
        String bizCode = this.template.getCode();
        DubboInvokeCacheKey key = new DubboInvokeCacheKey(bizCode, scenario = this.getScenario(), this.getExtensionCode());
        LatticeRemoteInvoker remoteInvoker = INVOKE_CACHE.get(key);
        if (null == remoteInvoker) {
            ApplicationConfig application = LatticeDubboRunnerEnv.getInstance().getApplication();
            RegistryConfig registry = LatticeDubboRunnerEnv.getInstance().getRegistry();
            ReferenceConfig reference = new ReferenceConfig();
            reference.setApplication(application);
            reference.setRegistry(registry);
            reference.setInterface(LatticeRemoteInvoker.class);
            reference.setVersion("1.0.0");
            reference.setGroup("lattice-" + bizCode);
            remoteInvoker = (LatticeRemoteInvoker)reference.get();
            INVOKE_CACHE.put(key, remoteInvoker);
        }
        return remoteInvoker.invoke(bizCode, scenario, this.getExtensionCode(), params.toArray());
    }

    @NotNull
    public List runAllMatched(IBizObject bizObject, ExtensionCallback callback, ExtensionRunner.RunnerExecuteResult executeResult) {
        return Collections.singletonList(this.runFirstMatched(bizObject, callback, executeResult));
    }

    public ExtensionRunnerType getType() {
        return ExtensionRunnerType.RMI;
    }

    public IAbility getAbility() {
        return this.ability;
    }

    public void setAbility(IAbility ability) {
        this.ability = ability;
    }

    public TemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(TemplateSpec template) {
        this.template = template;
    }

    public String getScenario() {
        return this.scenario;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }
}

