/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.remote.runner;

import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.extension.ExtensionRemoteRunner;
import org.hiforce.lattice.extension.RemoteExtensionRunnerBuilder;
import org.hiforce.lattice.model.ability.IAbility;
import org.hiforce.lattice.model.register.TemplateSpec;
import org.hiforce.lattice.remote.client.LatticeRemoteClient;
import org.hiforce.lattice.remote.client.model.RemoteBusiness;
import org.hiforce.lattice.remote.client.model.RemoteExtension;
import org.hiforce.lattice.remote.runner.DubboExtensionRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DubboRunnerBuilder
implements RemoteExtensionRunnerBuilder {
    private static final Logger log = LoggerFactory.getLogger(DubboRunnerBuilder.class);

    public <R> ExtensionRemoteRunner<R> build(IAbility ability, TemplateSpec templateSpec, String extCode, String scenario) {
        String bizCode = ability.getContext().getBizCode();
        RemoteBusiness remoteBusiness = LatticeRemoteClient.getInstance().getSupportRemoteBusinessList().stream().filter(p -> StringUtils.equals((CharSequence)p.getBizCode(), (CharSequence)bizCode)).findFirst().orElse(null);
        if (null == remoteBusiness) {
            log.debug("[Lattice-Remote] The business {} not support remote invoke.", (Object)bizCode);
            return null;
        }
        if (remoteBusiness.isForceSupportAllCodes()) {
            log.info("[Lattice-Remote] Force build the remote invoke runner for bizCode: {}", (Object)bizCode);
            return this.buildDubboExtensionRunner(RemoteExtension.of((String)extCode, (boolean)true), ability, templateSpec, extCode, scenario);
        }
        if (CollectionUtils.isEmpty((Collection)remoteBusiness.getExtensions())) {
            log.debug("[Lattice-Remote] Won't build remote invoke runner due to empty extension registered, bizCode: {}, extCode: {}", (Object)bizCode, (Object)extCode);
            return null;
        }
        RemoteExtension extension = remoteBusiness.getExtensions().stream().filter(p -> StringUtils.equals((CharSequence)p.getExtCode(), (CharSequence)extCode)).findFirst().orElse(null);
        if (null == extension) {
            log.debug("[Lattice-Remote] Won't build remote invoke runner due to specific extension not registered, bizCode: {}, extCode: {}", (Object)bizCode, (Object)extCode);
            return null;
        }
        log.debug("[Lattice-Remote] Create the remote runner for bizCode: {}, extCode: {}", (Object)bizCode, (Object)extCode);
        return this.buildDubboExtensionRunner(extension, ability, templateSpec, extCode, scenario);
    }

    private <R> DubboExtensionRunner<R> buildDubboExtensionRunner(RemoteExtension extension, IAbility ability, TemplateSpec templateSpec, String extCode, String scenario) {
        DubboExtensionRunner runner = new DubboExtensionRunner(extCode);
        runner.setRemoteExtension(extension);
        runner.setAbility(ability);
        runner.setTemplate(templateSpec);
        runner.setScenario(scenario);
        return runner;
    }
}

