/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.annotation.model.AbilityAnnotation;
import org.hifforce.lattice.exception.LatticeRuntimeException;
import org.hifforce.lattice.model.ability.IAbility;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.ability.execute.ExtensionCallback;
import org.hifforce.lattice.model.ability.execute.Reducer;
import org.hifforce.lattice.model.business.IBizObject;
import org.hifforce.lattice.model.context.AbilityContext;
import org.hiforce.lattice.runtime.ability.delegate.BaseLatticeAbilityDelegate;
import org.hiforce.lattice.runtime.ability.execute.ExecuteResult;
import org.hiforce.lattice.runtime.ability.execute.RunnerCollection;
import org.hiforce.lattice.runtime.ability.execute.filter.ExtensionFilter;
import org.hiforce.lattice.runtime.utils.LatticeAnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLatticeAbility<BusinessExt extends IBusinessExt>
implements IAbility<BusinessExt> {
    private static final Logger log = LoggerFactory.getLogger(BaseLatticeAbility.class);
    private final IBizObject bizObject;
    private final String instanceCode;
    private final BaseLatticeAbilityDelegate delegate;

    public BaseLatticeAbility(IBizObject bizObject) {
        this.bizObject = bizObject;
        this.instanceCode = this.getClass().getName();
        this.delegate = new BaseLatticeAbilityDelegate(this);
    }

    public AbilityContext getContext() {
        return new AbilityContext(this.bizObject);
    }

    public String getCode() {
        AbilityAnnotation annotation = LatticeAnnotationUtils.getAbilityAnnotation(this.getClass());
        if (null == annotation) {
            return null;
        }
        return annotation.getCode();
    }

    public boolean supportChecking() {
        return true;
    }

    public boolean supportCustomization() {
        return true;
    }

    public boolean hasDefaultExtension() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public final <T, R> R reduceExecute(String extensionCode, ExtensionCallback<BusinessExt, T> callback, @Nonnull Reducer<T, R> reducer) {
        ExecuteResult<R> result = this.reduceExecuteWithDetailResult(extensionCode, callback, reducer, ExtensionFilter.DEFAULT_FILTER);
        if (null == result || null == result.getResult()) {
            return null;
        }
        return result.getResult();
    }

    public final <T, R> R reduceExecute(String extensionCode, ExtensionCallback<BusinessExt, T> callback, @Nonnull Reducer<T, R> reducer, ExtensionFilter filter) {
        ExecuteResult<R> result = this.reduceExecuteWithDetailResult(extensionCode, callback, reducer, filter);
        if (null == result || null == result.getResult()) {
            return null;
        }
        return result.getResult();
    }

    protected <T, R> ExecuteResult<R> reduceExecuteWithDetailResult(String extensionCode, ExtensionCallback<BusinessExt, T> callback, @Nonnull Reducer<T, R> reducer, ExtensionFilter filter) {
        if (null == this.getContext().getBizObject()) {
            log.error("[Lattice]bizInstance is null, extensionCode: {}", (Object)extensionCode);
            return ExecuteResult.success(null, null, null);
        }
        if (this.getContext().getBizObject().getBizContext().getBizId() == null) {
            log.error("[Lattice]bizInstance id is null, extensionCode: {}", (Object)extensionCode);
            return ExecuteResult.success(null, null, null);
        }
        if (StringUtils.isEmpty((CharSequence)extensionCode)) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0007", new Object[0]);
        }
        String bizCode = this.getContext().getBizObject().getBizCode();
        if (StringUtils.isEmpty((CharSequence)bizCode)) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0008", new Object[0]);
        }
        ArrayList results = new ArrayList(16);
        RunnerCollection runnerCollection = this.delegate.loadExtensionRunners(extensionCode, filter);
        return runnerCollection.distinct().reduceExecute(reducer, callback, results);
    }

    public String getInstanceCode() {
        return this.instanceCode;
    }
}

