/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.execute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.hifforce.lattice.model.register.TemplateSpec;
import org.hiforce.lattice.runtime.ability.execute.RunnerExecutionStatus;
import org.hiforce.lattice.runtime.ability.execute.runner.ExtensionRunner;

public class ExecuteResult<R> {
    private R result;
    private final List<RunnerExecutionStatus> detailRunnerResults = new ArrayList<RunnerExecutionStatus>(10);
    private static final ExtensionRunner.CollectionRunnerExecuteResult DUMMY = new ExtensionRunner.CollectionRunnerExecuteResult();

    public static <T> ExecuteResult<T> success(T model, List<TemplateSpec> runners, List<ExtensionRunner.CollectionRunnerExecuteResult> executeResults) {
        ExecuteResult<T> result = new ExecuteResult<T>();
        result.setResult(model);
        if (CollectionUtils.isNotEmpty(runners)) {
            int totalLen = executeResults.size();
            for (int i = 0; i < runners.size(); ++i) {
                if (i < totalLen) {
                    result.detailRunnerResults.add(ExecuteResult.toRunnerExecutionStatus(runners.get(i), executeResults.get(i)));
                    continue;
                }
                result.detailRunnerResults.add(ExecuteResult.toRunnerExecutionStatus(runners.get(i), DUMMY));
            }
        }
        return result;
    }

    private static RunnerExecutionStatus toRunnerExecutionStatus(TemplateSpec runner, ExtensionRunner.CollectionRunnerExecuteResult executeResult) {
        RunnerExecutionStatus status = new RunnerExecutionStatus();
        if (null != runner) {
            status.setTemplateCode(runner.getCode());
            status.setTemplateType(runner.getType());
        }
        status.setExecuted(executeResult.isExecute());
        status.setInvokeResults(executeResult.getResults());
        status.setType(executeResult.getRunnerType());
        return status;
    }

    public R getResult() {
        return this.result;
    }

    public void setResult(R result) {
        this.result = result;
    }

    public List<RunnerExecutionStatus> getDetailRunnerResults() {
        return this.detailRunnerResults;
    }

    static {
        DUMMY.setResults(Collections.emptyList());
    }
}

