/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.execute;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.ability.execute.ExtensionCallback;
import org.hifforce.lattice.model.ability.execute.Reducer;
import org.hifforce.lattice.model.business.IBizObject;
import org.hifforce.lattice.model.register.TemplateSpec;
import org.hiforce.lattice.runtime.ability.execute.ExecuteResult;
import org.hiforce.lattice.runtime.ability.execute.runner.ExtensionRunner;
import org.hiforce.lattice.runtime.ability.execute.runner.ExtensionRunnerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnerCollection<ExtensionPoints, R> {
    private static final Logger log = LoggerFactory.getLogger(RunnerCollection.class);
    public static final Predicate ACCEPT_ALL = o -> true;
    public static final Producer PRODUCE_NULL = () -> null;
    private IBizObject bizInstance;
    private List<RunnerItemEntry<ExtensionPoints, R>> runnerList = Collections.emptyList();
    private Predicate<RunnerItemEntry<ExtensionPoints, R>> predicate = ACCEPT_ALL;
    private Producer<ExtensionPoints, R> defaultProducer = PRODUCE_NULL;
    private RunnerCollection<ExtensionPoints, R> parent;
    private List<InstantItem> finalColl;
    private boolean loadBizExt;
    private boolean loadDefaultExtension;

    private RunnerCollection() {
    }

    public static <ExtensionPoints, R> RunnerCollection<ExtensionPoints, R> of(IBizObject bizInstance, List<RunnerItemEntry<ExtensionPoints, R>> runnerList, Predicate<RunnerItemEntry<ExtensionPoints, R>> predicate, Producer<ExtensionPoints, R> defaultResult, boolean loadBizExt, boolean loadDefaultExtension) {
        RunnerCollection<ExtensionPoints, R> runnerCollection = new RunnerCollection<ExtensionPoints, R>();
        runnerCollection.bizInstance = bizInstance;
        runnerCollection.runnerList = runnerList;
        runnerCollection.predicate = predicate;
        if (defaultResult != null) {
            runnerCollection.defaultProducer = defaultResult;
        }
        runnerCollection.loadBizExt = loadBizExt;
        runnerCollection.loadDefaultExtension = loadDefaultExtension;
        return runnerCollection;
    }

    public static <ExtensionPoints, R> RunnerCollection<ExtensionPoints, R> of(IBizObject bizInstance, List<RunnerItemEntry<ExtensionPoints, R>> runnerList, Predicate<RunnerItemEntry<ExtensionPoints, R>> predicate) {
        return RunnerCollection.of(bizInstance, runnerList, predicate, null, false, false);
    }

    public static <ExtensionPoints, R> RunnerCollection<ExtensionPoints, R> combine(RunnerCollection<ExtensionPoints, R> runnerCollection, Producer<ExtensionPoints, R> producer, boolean loadBizExt, boolean loadDefaultExtension) {
        RunnerCollection<ExtensionPoints, R> runnerResult = new RunnerCollection<ExtensionPoints, R>();
        runnerResult.parent = runnerCollection;
        runnerResult.bizInstance = runnerCollection.bizInstance;
        if (producer != null) {
            runnerResult.defaultProducer = producer;
        }
        runnerResult.loadBizExt = loadBizExt;
        runnerResult.loadDefaultExtension = loadDefaultExtension;
        return runnerResult;
    }

    public static <ExtensionPoints, R> RunnerCollection<ExtensionPoints, R> combine(RunnerCollection<ExtensionPoints, R> runnerCollection, RunnerCollection<ExtensionPoints, R> runnerCollection2) {
        runnerCollection2.parent = runnerCollection;
        return runnerCollection2;
    }

    static <ExtensionPoints, R> RunnerCollection<ExtensionPoints, R> newEmptyCollection() {
        return new RunnerCollection<ExtensionPoints, R>();
    }

    RunnerCollection<ExtensionPoints, R> merge(RunnerCollection<ExtensionPoints, R> runnerCollection, IBizObject bizInstance) {
        RunnerCollection<ExtensionPoints, R> parent = this.parent;
        if (parent != null) {
            runnerCollection.parent = parent;
            this.parent = runnerCollection;
        } else {
            this.parent = runnerCollection;
        }
        runnerCollection.withBizInstance(bizInstance);
        return this;
    }

    RunnerCollection<ExtensionPoints, R> withBizInstance(IBizObject bizInstance) {
        this.bizInstance = bizInstance;
        RunnerCollection<ExtensionPoints, R> parent = this.parent;
        while (parent != null && parent.bizInstance == null) {
            parent.bizInstance = bizInstance;
            parent = parent.parent;
        }
        return this;
    }

    private <T> List<InstantItem<ExtensionPoints, T>> generateInstantItem() {
        List<InstantItem> result = this.finalColl;
        if (result == null) {
            result = new ArrayList<InstantItem<ExtensionPoints, T>>(32);
            this.collect(result);
            this.finalColl = result;
        }
        return result;
    }

    private void collect(List<InstantItem> result) {
        RunnerCollection<ExtensionPoints, R> parent = this.parent;
        if (parent != null) {
            super.collect(result);
        }
        boolean skipDefault = false;
        IBizObject bizInstance = this.bizInstance;
        List<RunnerItemEntry<ExtensionPoints, R>> runnerList = this.runnerList;
        if (runnerList != null) {
            RunnerItemEntry<ExtensionPoints, R> defaultItem;
            Predicate<RunnerItemEntry<ExtensionPoints, R>> predicate = this.predicate;
            for (RunnerItemEntry<ExtensionPoints, R> item : this.runnerList) {
                boolean t = predicate.test(item);
                skipDefault |= t;
                if (!t) continue;
                result.add(new InstantItem<ExtensionPoints, R>(item, bizInstance));
            }
            if (!skipDefault && this.loadBizExt && (defaultItem = this.defaultProducer.produce()) != null) {
                result.add(new InstantItem<ExtensionPoints, R>(defaultItem, bizInstance));
            }
        }
    }

    private void updateResult(List result) {
        this.finalColl = result;
    }

    RunnerCollection<ExtensionPoints, R> sort() {
        List result = this.generateInstantItem();
        result.sort(Comparator.comparingInt(p -> p.runnerItemEntry.extensionRunner.getPriority()));
        return this;
    }

    public RunnerCollection<ExtensionPoints, R> distinct() {
        List<InstantItem<ExtensionPoints, R>> result = this.generateInstantItem();
        result = this.distinctRunners(result);
        this.updateResult(result);
        return this;
    }

    private List<InstantItem<ExtensionPoints, R>> distinctRunners(List<InstantItem<ExtensionPoints, R>> runners) {
        ArrayList<InstantItem<ExtensionPoints, R>> output = new ArrayList<InstantItem<ExtensionPoints, R>>(runners.size());
        HashMap map = Maps.newHashMap();
        for (InstantItem<ExtensionPoints, R> runner : runners) {
            if (null == runner.runnerItemEntry.template) {
                output.add(runner);
                continue;
            }
            Set set = map.computeIfAbsent(runner.runnerItemEntry.getRunnerType(), k -> Sets.newHashSet());
            boolean newAdd = set.add(runner.runnerItemEntry.template.getCode());
            if (!newAdd) continue;
            output.add(runner);
        }
        return output;
    }

    public <T, R> ExecuteResult<R> reduceExecute(Reducer<T, R> reducer, ExtensionCallback<IBusinessExt, T> callback, List<T> results) {
        List<InstantItem<ExtensionPoints, T>> list = this.generateInstantItem();
        if (list.isEmpty()) {
            return ExecuteResult.success(reducer.reduce(results), null, null);
        }
        ArrayList<ExtensionRunner.CollectionRunnerExecuteResult> executeResults = new ArrayList<ExtensionRunner.CollectionRunnerExecuteResult>(list.size() * 2);
        for (InstantItem<ExtensionPoints, T> item : list) {
            ExtensionRunner.CollectionRunnerExecuteResult executeResult = new ExtensionRunner.CollectionRunnerExecuteResult();
            List<T> itemResult = item.runAllMatched(callback, executeResult);
            executeResult.setResults(itemResult);
            executeResults.add(executeResult);
            if (reducer.willBreak(itemResult)) {
                return ExecuteResult.success(reducer.reduce(itemResult), this.convertToTemplateList(list), executeResults);
            }
            if (itemResult.size() == 1) {
                results.add(itemResult.get(0));
                continue;
            }
            results.addAll(itemResult);
        }
        return ExecuteResult.success(reducer.reduce(results), this.convertToTemplateList(list), executeResults);
    }

    private <T> List<TemplateSpec> convertToTemplateList(List<InstantItem<ExtensionPoints, T>> list) {
        ArrayList<TemplateSpec> templates = new ArrayList<TemplateSpec>(list.size());
        list.forEach(p -> templates.add(p.runnerItemEntry.template));
        return templates;
    }

    private static class InstantItem<ExtensionPoints, R> {
        RunnerItemEntry<ExtensionPoints, R> runnerItemEntry;
        IBizObject bizInstance;

        public InstantItem(RunnerItemEntry<ExtensionPoints, R> runnerItemEntry, IBizObject bizInstance) {
            this.runnerItemEntry = runnerItemEntry;
            this.bizInstance = bizInstance;
        }

        public List<R> runAllMatched(ExtensionCallback<IBusinessExt, R> callback, ExtensionRunner.RunnerExecuteResult executeResult) {
            RunnerItemEntry<ExtensionPoints, R> entry = this.runnerItemEntry;
            try {
                return entry.extensionRunner.runAllMatched(entry.abilityInstance, this.bizInstance, callback, executeResult);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    public static interface Producer<ExtensionPoints, R> {
        public RunnerItemEntry<ExtensionPoints, R> produce();
    }

    public static class RunnerItemEntry<ExtensionPoints, R> {
        TemplateSpec template;
        ExtensionRunner<ExtensionPoints, R> extensionRunner;
        Object abilityInstance;

        public ExtensionRunnerType getRunnerType() {
            return this.extensionRunner.getType();
        }

        public RunnerItemEntry(TemplateSpec template, ExtensionRunner<ExtensionPoints, R> extensionRunner, Object abilityInstance) {
            this.template = template;
            this.extensionRunner = extensionRunner;
            this.abilityInstance = abilityInstance;
        }

        public String toString() {
            return "[" + (this.template != null ? this.template.getCode() : null) + "|" + (this.extensionRunner.getModel() != null ? this.extensionRunner.getModel().getClass().getName() : null) + "]";
        }

        public TemplateSpec getTemplate() {
            return this.template;
        }
    }
}

