/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.register;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hifforce.lattice.annotation.model.AbilityAnnotation;
import org.hifforce.lattice.annotation.model.ExtensionAnnotation;
import org.hifforce.lattice.annotation.model.ReduceType;
import org.hifforce.lattice.annotation.parser.AbilityAnnotationParser;
import org.hifforce.lattice.exception.LatticeRuntimeException;
import org.hifforce.lattice.message.Message;
import org.hifforce.lattice.model.ability.IAbility;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.register.AbilityInstSpec;
import org.hifforce.lattice.model.register.AbilitySpec;
import org.hifforce.lattice.model.register.BaseSpec;
import org.hifforce.lattice.model.register.ExtensionPointSpec;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.ability.register.AbilityBuildRequest;
import org.hiforce.lattice.runtime.ability.register.AbilityInstBuildResult;
import org.hiforce.lattice.runtime.cache.LatticeRuntimeCache;
import org.hiforce.lattice.runtime.spi.LatticeSpiFactory;
import org.hiforce.lattice.runtime.utils.ExtensionUtils;
import org.hiforce.lattice.runtime.utils.LatticeBeanUtils;
import org.hiforce.lattice.runtime.utils.LatticeClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;

public class AbilityRegister {
    private static final Logger log = LoggerFactory.getLogger(AbilityRegister.class);
    private static final ThreadLocal<ClassLoader> CLASS_LOADER_THREAD_LOCAL = new ThreadLocal();
    private static AbilityRegister instance;

    private AbilityRegister() {
    }

    public static AbilityRegister getInstance() {
        if (null == instance) {
            instance = new AbilityRegister();
        }
        return instance;
    }

    public LatticeRuntimeCache getRuntimeCache() {
        return Lattice.getInstance().getLatticeRuntimeCache();
    }

    public List<AbilitySpec> register(AbilityBuildRequest regDTO) {
        ArrayList<AbilitySpec> abilitySpecList = new ArrayList<AbilitySpec>();
        for (Class currentClass : regDTO.getClassSet()) {
            Pair<AbilityAnnotation, Class<?>> pair = this.findAbilityAnnotationAndAbilityClass(currentClass);
            if (null == pair) continue;
            AbilityAnnotation ability = (AbilityAnnotation)pair.getLeft();
            Class targetClass = (Class)pair.getRight();
            if (null == ability || null != regDTO.getParent() && !ability.getParent().equals(regDTO.getParent().getCode())) continue;
            AbilitySpec abilitySpec = this.getRuntimeCache().doCacheAbilitySpec(ability, targetClass);
            abilitySpecList.add(abilitySpec);
            abilitySpec.addAbilityInstance(this.scanAbilityInstance(abilitySpec, regDTO.getClassSet()));
        }
        return abilitySpecList;
    }

    private Pair<AbilityAnnotation, Class<?>> findAbilityAnnotationAndAbilityClass(Class<?> currentClass) {
        List<AbilityAnnotationParser> parsers = LatticeSpiFactory.getInstance().getAbilityAnnotationParsers();
        for (AbilityAnnotationParser parser : parsers) {
            Object annotation = currentClass.getDeclaredAnnotation(parser.getAnnotationClass());
            if (null == annotation) continue;
            AbilityAnnotation annotationInfo = parser.buildAnnotationInfo(annotation, currentClass);
            return Pair.of((Object)annotationInfo, currentClass);
        }
        return null;
    }

    public synchronized List<AbilityInstSpec> scanAbilityInstance(AbilitySpec abilitySpec, Collection<Class> classSet) {
        ArrayList<AbilityInstSpec> abilityInstanceSpecList = new ArrayList<AbilityInstSpec>(this.registerAbilityInstances(abilitySpec, classSet));
        abilityInstanceSpecList.sort(Comparator.comparingInt(AbilityInstSpec::getPriority));
        return abilityInstanceSpecList;
    }

    private List<AbilityInstSpec> registerAbilityInstances(AbilitySpec abilitySpec, Collection<Class> classSet) {
        ArrayList<AbilityInstSpec> instanceSpecs = new ArrayList<AbilityInstSpec>();
        for (Class targetClass : classSet) {
            if (Modifier.isAbstract(targetClass.getModifiers()) || Modifier.isInterface(targetClass.getModifiers()) || !LatticeClassUtils.isSubClassOf(targetClass, abilitySpec.getAbilityClass())) continue;
            AbilityInstBuildResult result = this.innerRegisterAbilityInstance(abilitySpec, targetClass);
            if (!result.isSuccess() && !result.isRegistered()) {
                Message message = null == result.getMessage() ? Message.code((String)"LATTICE-CORE-RT-0001", (Object[])new Object[]{targetClass.getName(), "not clear"}) : result.getMessage();
                throw new LatticeRuntimeException(message);
            }
            AbilityInstSpec abilityInstanceSpec = result.getInstanceSpec();
            if (null == abilityInstanceSpec) continue;
            instanceSpecs.add(abilityInstanceSpec);
        }
        return instanceSpecs;
    }

    private AbilityInstBuildResult innerRegisterAbilityInstance(AbilitySpec abilitySpec, Class<?> instanceClass) {
        AbilityInstSpec abilityInstanceSpec;
        IAbility originAbility;
        IAbility ability;
        Object beanViaClass = LatticeBeanUtils.getAndCreateSpringBeanViaClass(instanceClass, null);
        if (beanViaClass instanceof IAbility) {
            ability = (IAbility)beanViaClass;
            if (AopUtils.isAopProxy((Object)ability)) {
                Class originCls = AopUtils.getTargetClass((Object)ability);
                try {
                    Object curObject = LatticeBeanUtils.getAndCreateSpringBeanViaClass(originCls, null);
                    originAbility = (IAbility)curObject;
                }
                catch (Exception e) {
                    return AbilityInstBuildResult.failed(Message.code((String)"LATTICE-CORE-RT-0002", (Object[])new Object[]{originCls.getName()}));
                }
            } else {
                originAbility = ability;
            }
        } else {
            return AbilityInstBuildResult.failed(Message.code((String)"LATTICE-CORE-RT-0002", (Object[])new Object[]{instanceClass.getName()}));
        }
        if (null != Lattice.getInstance().getAbilityProvider().getRealization(originAbility.getInstanceCode())) {
            if (this.isAbilityInstanceRegistered(abilitySpec, originAbility)) {
                return AbilityInstBuildResult.registered();
            }
            return this.buildAbilityInstanceSpec(abilitySpec, originAbility, instanceClass);
        }
        AbilityInstBuildResult result = this.buildAbilityInstanceSpec(abilitySpec, originAbility, instanceClass);
        if (result.isSuccess() && null != (abilityInstanceSpec = result.getInstanceSpec())) {
            Lattice.getInstance().getAbilityProvider().registerRealization(ability, originAbility.getInstanceCode());
        }
        return result;
    }

    private boolean isAbilityInstanceRegistered(AbilitySpec abilitySpec, IAbility instance) {
        return abilitySpec.getAbilityInstSpecMap().values().stream().anyMatch(p -> p.getCode().equals(instance.getInstanceCode()));
    }

    private AbilityInstBuildResult buildAbilityInstanceSpec(AbilitySpec abilitySpec, IAbility instance, Class<?> instanceClass) {
        try {
            AbilityInstSpec instanceDesc = new AbilityInstSpec();
            instanceDesc.setInstanceClass(instanceClass.getName());
            instanceDesc.setCode(instance.getInstanceCode());
            instanceDesc.setName(instanceClass.getSimpleName());
            instanceDesc.getExtensions().addAll(this.scanAbilityExtensions(instance, abilitySpec));
            abilitySpec.addAbilityInstance(instanceDesc);
            return AbilityInstBuildResult.success(instanceDesc);
        }
        catch (Exception e) {
            return AbilityInstBuildResult.failed(Message.code((String)"LATTICE-CORE-RT-0003", (Object[])new Object[]{instanceClass, e.getMessage()}));
        }
    }

    private Set<ExtensionPointSpec> scanAbilityExtensions(IAbility domainAbility, AbilitySpec abilitySpec) {
        try {
            Method[] methods;
            HashSet<ExtensionPointSpec> extensionPointSpecList = new HashSet<ExtensionPointSpec>();
            Class<?> returnType = this.findAbilityExtensionDefinition(domainAbility.getClass());
            if (null != returnType) {
                extensionPointSpecList.addAll(this.scanAbilityExtensions(Sets.newHashSet(), returnType, abilitySpec));
            }
            for (Method method : methods = domainAbility.getClass().getMethods()) {
                returnType = method.getReturnType();
                if (!ClassUtils.isAssignable(returnType, IBusinessExt.class)) continue;
                extensionPointSpecList.addAll(this.scanAbilityExtensions(extensionPointSpecList.stream().map(BaseSpec::getCode).collect(Collectors.toSet()), returnType, abilitySpec));
            }
            return extensionPointSpecList;
        }
        catch (Throwable th) {
            Message message = Message.code((String)"LATTICE-CORE-RT-0004", (Object[])new Object[]{domainAbility.getClass().getName(), th.getMessage()});
            log.error(message.getText(), th);
            throw th;
        }
    }

    private Class<?> findAbilityExtensionDefinition(Class abilityClass) {
        Type genericSuperclass = abilityClass.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericSuperclass;
            for (Type actualType : type.getActualTypeArguments()) {
                try {
                    Class<?> returnType = CLASS_LOADER_THREAD_LOCAL.get() != null ? Class.forName(actualType.getTypeName(), true, CLASS_LOADER_THREAD_LOCAL.get()) : Class.forName(actualType.getTypeName());
                    if (ClassUtils.isAssignable(returnType, IBusinessExt.class)) {
                        return returnType;
                    }
                }
                catch (ClassNotFoundException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (ClassUtils.isAssignable(abilityClass.getSuperclass(), IAbility.class)) {
            return this.findAbilityExtensionDefinition(abilityClass.getSuperclass());
        }
        return null;
    }

    private Set<ExtensionPointSpec> scanAbilityExtensions(Set<String> existedSet, Class<?> itfClass, AbilitySpec abilitySpec) {
        Method[] methods;
        HashSet<ExtensionPointSpec> extensionPointSpecList = new HashSet<ExtensionPointSpec>();
        for (Method method : methods = itfClass.getMethods()) {
            ExtensionPointSpec extensionPointSpec;
            ExtensionAnnotation annotation = ExtensionUtils.getExtensionAnnotation(method);
            if (null == annotation || existedSet.contains(annotation.getCode()) || null == (extensionPointSpec = this.buildExtensionPointSpec(annotation, abilitySpec, itfClass, method))) continue;
            extensionPointSpecList.add(extensionPointSpec);
        }
        return extensionPointSpecList;
    }

    public ExtensionPointSpec buildExtensionPointSpec(ExtensionAnnotation annotation, AbilitySpec abilitySpec, Class<?> itfClass, Method method) {
        if (null == annotation) {
            return null;
        }
        return this.buildExtensionPointSpec(abilitySpec, annotation.getCode(), annotation.getName(), annotation.getDesc(), itfClass, method, annotation.getReduceType());
    }

    private ExtensionPointSpec buildExtensionPointSpec(AbilitySpec abilitySpec, String extensionCode, String extensionName, String extensionDesc, Class<?> itfClass, Method method, ReduceType reduceType) {
        ExtensionPointSpec extensionPointSpec = ExtensionPointSpec.of((Method)method, (String)abilitySpec.getCode(), (String)extensionCode, (String)extensionName, (String)extensionDesc);
        extensionPointSpec.setReduceType(reduceType);
        extensionPointSpec.setItfClass(itfClass);
        return extensionPointSpec;
    }
}

