/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.register;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.annotation.model.BusinessAnnotation;
import org.hifforce.lattice.annotation.model.ProductAnnotation;
import org.hifforce.lattice.annotation.model.RealizationAnnotation;
import org.hifforce.lattice.annotation.parser.BusinessAnnotationParser;
import org.hifforce.lattice.annotation.parser.ProductAnnotationParser;
import org.hifforce.lattice.annotation.parser.RealizationAnnotationParser;
import org.hifforce.lattice.exception.LatticeRuntimeException;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hifforce.lattice.model.register.BusinessSpec;
import org.hifforce.lattice.model.register.ProductSpec;
import org.hifforce.lattice.model.register.RealizationSpec;
import org.hifforce.lattice.utils.BizCodeUtils;
import org.hiforce.lattice.runtime.spi.LatticeSpiFactory;
import org.hiforce.lattice.runtime.utils.BusinessExtUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class TemplateRegister {
    private static TemplateRegister instance;
    private final List<RealizationSpec> realizations = Lists.newArrayList();
    private final List<ProductSpec> products = Lists.newArrayList();
    private final List<BusinessSpec> businesses = Lists.newArrayList();

    private TemplateRegister() {
    }

    public static TemplateRegister getInstance() {
        if (null == instance) {
            instance = new TemplateRegister();
        }
        return instance;
    }

    public List<BusinessSpec> registerBusinesses(Set<Class> classSet) {
        for (Class clz : classSet) {
            BusinessAnnotation annotation = this.getBusinessAnnotation(clz);
            if (null == annotation) continue;
            BusinessSpec businessSpec = new BusinessSpec();
            businessSpec.setBusinessClass(clz);
            businessSpec.setCode(annotation.getCode());
            businessSpec.setName(annotation.getName());
            businessSpec.setDescription(annotation.getDesc());
            businessSpec.setPriority(annotation.getPriority());
            businessSpec.getRealizations().addAll(this.realizations.stream().filter(p -> BizCodeUtils.isCodesMatched((String)p.getCode(), (String)businessSpec.getCode())).collect(Collectors.toList()));
            this.businesses.add(businessSpec);
        }
        return this.businesses;
    }

    public List<ProductSpec> registerProducts(Set<Class> classSet) {
        for (Class clz : classSet) {
            ProductAnnotation annotation = this.getProductAnnotation(clz);
            if (null == annotation) continue;
            ProductSpec productSpec = new ProductSpec();
            productSpec.setProductClass(clz);
            productSpec.setCode(annotation.getCode());
            productSpec.setName(annotation.getName());
            productSpec.setDescription(annotation.getDesc());
            productSpec.setType(annotation.getType());
            productSpec.setPriority(annotation.getPriority());
            productSpec.setBusinessExt(annotation.getBusinessExt());
            productSpec.getRealizations().addAll(this.realizations.stream().filter(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)productSpec.getCode())).collect(Collectors.toList()));
            this.products.add(productSpec);
        }
        return this.products;
    }

    public List<RealizationSpec> registerRealizations(Set<Class> classSet) {
        for (Class clz : classSet) {
            RealizationAnnotation annotation = this.getRealizationAnnotation(clz);
            if (null == annotation) continue;
            for (String code : annotation.getCodes()) {
                RealizationSpec spec = new RealizationSpec();
                spec.setCode(code);
                spec.setScenario(annotation.getScenario());
                spec.setBusinessExtClass(annotation.getBusinessExtClass());
                try {
                    spec.setBusinessExt((IBusinessExt)annotation.getBusinessExtClass().newInstance());
                }
                catch (Exception e) {
                    throw new LatticeRuntimeException("LATTICE-CORE-RT-0006", new Object[]{clz.getName()});
                }
                spec.getExtensionCodes().addAll(BusinessExtUtils.supportedExtCodes(spec.getBusinessExt()));
                this.realizations.add(spec);
            }
        }
        return this.realizations;
    }

    private BusinessAnnotation getBusinessAnnotation(Class targetClass) {
        for (BusinessAnnotationParser parser : LatticeSpiFactory.getInstance().getBusinessAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.findAnnotation((Class)targetClass, (Class)parser.getAnnotationClass());
            if (null == annotation) continue;
            BusinessAnnotation info = new BusinessAnnotation();
            info.setName(parser.getName(annotation));
            info.setCode(parser.getCode(annotation));
            info.setDesc(parser.getDesc(annotation));
            info.setPriority(parser.getPriority(annotation));
            return info;
        }
        return null;
    }

    private ProductAnnotation getProductAnnotation(Class targetClass) {
        for (ProductAnnotationParser parser : LatticeSpiFactory.getInstance().getProductAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.findAnnotation((Class)targetClass, (Class)parser.getAnnotationClass());
            if (null == annotation) continue;
            ProductAnnotation info = new ProductAnnotation();
            info.setName(parser.getName(annotation));
            info.setCode(parser.getCode(annotation));
            info.setType(parser.getType(annotation));
            info.setDesc(parser.getDesc(annotation));
            info.setPriority(parser.getPriority(annotation));
            return info;
        }
        return null;
    }

    private RealizationAnnotation getRealizationAnnotation(Class targetClass) {
        for (RealizationAnnotationParser parser : LatticeSpiFactory.getInstance().getRealizationAnnotationParsers()) {
            Annotation annotation = AnnotationUtils.findAnnotation((Class)targetClass, (Class)parser.getAnnotationClass());
            if (null == annotation) continue;
            RealizationAnnotation info = new RealizationAnnotation();
            info.setScenario(parser.getScenario(annotation));
            info.setCodes(parser.getCodes(annotation));
            if (!ClassUtils.isAssignable((Class)targetClass, IBusinessExt.class)) {
                throw new LatticeRuntimeException("LATTICE-CORE-RT-0005", new Object[]{targetClass.getName()});
            }
            info.setBusinessExtClass(targetClass);
            return info;
        }
        return null;
    }

    public List<RealizationSpec> getRealizations() {
        return this.realizations;
    }

    public List<ProductSpec> getProducts() {
        return this.products;
    }

    public List<BusinessSpec> getBusinesses() {
        return this.businesses;
    }
}

