/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import org.hifforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.runtime.cache.NotExistedExtensionPointRealization;
import org.hiforce.lattice.runtime.cache.key.ExtensionInvokeCacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionInvokeCache {
    private static final Logger log = LoggerFactory.getLogger(ExtensionInvokeCache.class);
    private static ExtensionInvokeCache INSTANCE;
    private static final Object LOCK;
    private final Map<Long, IBusinessExt> EXT_REALIZATION_CACHE = new ConcurrentHashMap<Long, IBusinessExt>(2000);
    private ForkJoinPool forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());

    private ExtensionInvokeCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionInvokeCache getInstance() {
        if (null == INSTANCE) {
            Object object = LOCK;
            synchronized (object) {
                if (null == INSTANCE) {
                    INSTANCE = new ExtensionInvokeCache();
                }
            }
        }
        return INSTANCE;
    }

    public IBusinessExt doCacheExtensionRealization(ExtensionInvokeCacheKey cacheKey, IBusinessExt realization) {
        this.EXT_REALIZATION_CACHE.putIfAbsent(cacheKey.getUniqueId(), null == realization ? new NotExistedExtensionPointRealization() : realization);
        return realization;
    }

    public IBusinessExt getCachedExtensionRealization(ExtensionInvokeCacheKey cacheKey) {
        if (null == cacheKey) {
            return null;
        }
        return this.EXT_REALIZATION_CACHE.get(cacheKey.getUniqueId());
    }

    static {
        LOCK = new Object();
    }
}

