/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.cache;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.hifforce.lattice.annotation.model.AbilityAnnotation;
import org.hifforce.lattice.cache.ILatticeRuntimeCache;
import org.hifforce.lattice.model.ability.IAbility;
import org.hifforce.lattice.model.ability.cache.IBusinessExtCache;
import org.hifforce.lattice.model.business.BusinessTemplate;
import org.hifforce.lattice.model.business.IProduct;
import org.hifforce.lattice.model.register.AbilitySpec;
import org.hifforce.lattice.model.register.BaseSpec;
import org.hifforce.lattice.model.register.ExtensionPointSpec;
import org.hifforce.lattice.model.register.RealizationSpec;
import org.hifforce.lattice.sequence.SequenceGenerator;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.ability.cache.BusinessExtCache;
import org.hiforce.lattice.runtime.cache.ExtensionRunnerCacheKey;
import org.hiforce.lattice.runtime.cache.SimpleCache;
import org.hiforce.lattice.runtime.cache.TemplateCache;

@AutoService(value={ILatticeRuntimeCache.class})
public class LatticeRuntimeCache
extends SimpleCache
implements ILatticeRuntimeCache {
    public TemplateCache CACHE_TEMPLATE_REALIZATION = new TemplateCache();
    private final Map<Class<?>, Map<Long, Object>> abilityExtRunnerCollectionCache = new ConcurrentHashMap();
    private boolean extensionRunnerCacheReady = false;
    public static Map<String, Long> BIZ_CODE_IDX_MAP = new ConcurrentHashMap<String, Long>(120);
    public static Map<String, Long> SCENARIO_IDX_MAP = new ConcurrentHashMap<String, Long>(120);

    public IBusinessExtCache getBusinessExtCache() {
        return BusinessExtCache.getInstance();
    }

    public AbilitySpec doCacheAbilitySpec(AbilityAnnotation ability, Class<?> targetClass) {
        String abilityCode = StringUtils.isEmpty((CharSequence)ability.getCode()) ? targetClass.getName() : ability.getCode();
        AbilitySpec abilitySpec = this.getAbilitySpecEntry(abilityCode);
        if (null == abilitySpec) {
            abilitySpec = AbilitySpec.of((String)abilityCode, (String)ability.getName(), (String)ability.getDesc());
            abilitySpec.setAbilityClass(targetClass);
            if (StringUtils.isNotEmpty((CharSequence)ability.getParent())) {
                abilitySpec.setParentCode(ability.getParent());
            }
            return this.doCacheObjectAbilitySpec(abilityCode, abilitySpec);
        }
        return abilitySpec;
    }

    public Collection<AbilitySpec> getAllCachedAbilities() {
        return this.getAllCacheAbilitySpec();
    }

    public TemplateCache getTemplateCache() {
        return this.CACHE_TEMPLATE_REALIZATION;
    }

    public Object getCachedExtensionRunner(IAbility ability, ExtensionRunnerCacheKey key) {
        Map<Long, Object> cache = this.abilityExtRunnerCollectionCache.get(ability.getClass());
        if (null == cache) {
            return null;
        }
        return cache.get(key.getUniqueId());
    }

    public synchronized void buildExtensionRunnerCache() {
        if (this.extensionRunnerCacheReady) {
            return;
        }
        List<ExtensionPointSpec> extensions = Lattice.getInstance().getAllRegisteredAbilities().stream().flatMap(p -> p.getAbilityInstances().stream()).flatMap(p -> p.getExtensions().stream()).collect(Collectors.toList());
        extensions.forEach(p -> this.getExtensionSpecCache().put(p.getCode().intern(), p.getInternalId(), p));
        Lattice.getInstance().getAllRegisteredBusinesses().stream().map(BaseSpec::getCode).forEach(bizCode -> BIZ_CODE_IDX_MAP.put((String)bizCode, SequenceGenerator.next((String)BusinessTemplate.class.getName())));
        long scenarioIdx = 1L;
        List<RealizationSpec> realizationSpecs = Lattice.getInstance().getAllRealizations();
        for (RealizationSpec realizationSpec : realizationSpecs) {
            if (StringUtils.isEmpty((CharSequence)realizationSpec.getScenario())) continue;
            SCENARIO_IDX_MAP.putIfAbsent(realizationSpec.getScenario(), scenarioIdx++);
        }
        LatticeRuntimeCache latticeRuntimeCache = Lattice.getInstance().getLatticeRuntimeCache();
        Lattice.getInstance().getAllRegisteredProducts().forEach(p -> {
            BaseSpec cfr_ignored_0 = (BaseSpec)latticeRuntimeCache.getTemplateCache().put(p.getCode(), SequenceGenerator.next((String)IProduct.class.getName()), p);
        });
        Lattice.getInstance().getAllRegisteredBusinesses().forEach(p -> {
            BaseSpec cfr_ignored_0 = (BaseSpec)latticeRuntimeCache.getTemplateCache().put(p.getCode(), SequenceGenerator.next((String)IProduct.class.getName()), p);
        });
        this.extensionRunnerCacheReady = true;
    }

    public void doCacheExtensionRunner(IAbility ability, ExtensionRunnerCacheKey key, Object runner) {
        Map<Long, Object> cache = this.abilityExtRunnerCollectionCache.get(ability.getClass());
        if (MapUtils.isEmpty(cache)) {
            cache = new ConcurrentHashMap<Long, Object>(200);
            this.abilityExtRunnerCollectionCache.put(ability.getClass(), cache);
        }
        cache.put(key.getUniqueId(), runner);
    }

    public boolean isExtensionRunnerCacheReady() {
        return this.extensionRunnerCacheReady;
    }
}

