/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.runtime.utils.ClassNameComparator;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathScanHandler {
    private static final Logger log = LoggerFactory.getLogger(ClassPathScanHandler.class);
    private static final String CLASS_EXTENSION_NAME = ".class";
    private boolean excludeInner = true;
    private boolean checkInOrEx = true;
    private List<String> classFilters = null;
    private Reflections reflections = null;
    private static final Map<ClassLoader, Map<String, Set<Class<?>>>> cachedClassloaderClassSetMap = new HashMap();

    public synchronized Set<Class<?>> getPackageAllClasses(String basePackage, boolean recursive) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Set<Class<?>> cachedClassSet = null;
        String cacheKey = basePackage + "," + recursive;
        Map<String, Set<Class<?>>> cachedClassSetMap = cachedClassloaderClassSetMap.get(classLoader);
        if (cachedClassSetMap == null) {
            cachedClassSetMap = new HashMap();
        }
        if ((cachedClassSet = cachedClassSetMap.get(cacheKey)) == null) {
            cachedClassSet = this.innerGetPackageAllClasses(basePackage, recursive);
            if (cachedClassSet == null) {
                cachedClassSet = new HashSet();
            }
            cachedClassSetMap.put(cacheKey, cachedClassSet);
            cachedClassloaderClassSetMap.put(classLoader, cachedClassSetMap);
        }
        return cachedClassSet;
    }

    public synchronized Set<Class<?>> innerGetPackageAllClasses(String basePackage, boolean recursive) {
        if (StringUtils.isEmpty((CharSequence)basePackage)) {
            return new HashSet();
        }
        LinkedHashSet classes = new LinkedHashSet();
        String packageName = basePackage;
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.lastIndexOf(46));
        }
        String package2Path = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(package2Path);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    this.doScanPackageClassesByFile(classes, packageName, filePath, recursive);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                this.doScanPackageClassesByJar(packageName, url, recursive, classes);
            }
        }
        catch (IOException e) {
            log.error("IOException error:", (Throwable)e);
        }
        TreeSet sortedClasses = new TreeSet(new ClassNameComparator());
        sortedClasses.addAll(classes);
        return sortedClasses;
    }

    private void doScanPackageClassesByJar(String basePackage, URL url, boolean recursive, Set<Class<?>> classes) {
        String package2Path = basePackage.replace('.', '/');
        try {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(package2Path) || entry.isDirectory() || !recursive && name.lastIndexOf(47) != package2Path.length()) continue;
                if (this.excludeInner && name.indexOf(36) != -1) {
                    log.debug("exclude inner class with name:" + name);
                    continue;
                }
                String classSimpleName = name.substring(name.lastIndexOf(47) + 1);
                if (!this.filterClassName(classSimpleName)) continue;
                String className = name.replace('/', '.');
                className = className.substring(0, className.length() - 6);
                try {
                    classes.add(Thread.currentThread().getContextClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    log.error("LoadClass Exception:URL is ===>" + url.getPath() + " , Class ===> " + className, (Throwable)e);
                }
                catch (NoClassDefFoundError error) {
                    log.error("LoadClass error:URL is ===>" + url.getPath() + " , Class ===> " + className, (Throwable)error);
                }
            }
        }
        catch (IOException e) {
            log.error("IOException error:URL is ===>" + url.getPath(), (Throwable)e);
        }
        catch (Throwable e) {
            log.error("ScanPackageClassesByJar error:URL is ===>" + url.getPath(), e);
        }
    }

    private void doScanPackageClassesByFile(Set<Class<?>> classes, String packageName, String packagePath, final boolean recursive) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return ClassPathScanHandler.this.filterClassFileByCustomization(pathname, recursive);
            }
        });
        if (null == files || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.doScanPackageClassesByFile(classes, packageName + "." + file.getName(), file.getAbsolutePath(), recursive);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - CLASS_EXTENSION_NAME.length());
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                log.error("LoadClass exception: ===>" + className, (Throwable)e);
            }
            catch (NoClassDefFoundError error) {
                log.error("LoadClass error: ===>" + className, (Throwable)error);
            }
        }
    }

    private boolean filterClassFileByCustomization(@Nonnull File file, boolean recursive) {
        if (file.isDirectory()) {
            return recursive;
        }
        String filename = file.getName();
        if (this.excludeInner && filename.indexOf(36) != -1) {
            log.debug("exclude inner class with name:" + filename);
            return false;
        }
        return this.filterClassName(filename);
    }

    private boolean filterClassName(String className) {
        String str;
        if (!className.endsWith(CLASS_EXTENSION_NAME)) {
            return false;
        }
        if (null == this.classFilters || this.classFilters.isEmpty()) {
            return true;
        }
        String tmpName = className.substring(0, className.length() - 6);
        boolean flag = false;
        Iterator<String> iterator = this.classFilters.iterator();
        while (iterator.hasNext() && !(flag = this.matchInnerClassname(tmpName, str = iterator.next()))) {
        }
        return this.checkInOrEx && flag || !this.checkInOrEx && !flag;
    }

    private boolean matchInnerClassname(String className, String filterString) {
        String reg = "^" + filterString.replace("*", ".*") + "$";
        Pattern p = Pattern.compile(reg);
        return p.matcher(className).find();
    }

    public static void clearCache() {
        cachedClassloaderClassSetMap.clear();
    }

    public boolean isExcludeInner() {
        return this.excludeInner;
    }

    public void setExcludeInner(boolean excludeInner) {
        this.excludeInner = excludeInner;
    }

    public boolean isCheckInOrEx() {
        return this.checkInOrEx;
    }

    public void setCheckInOrEx(boolean checkInOrEx) {
        this.checkInOrEx = checkInOrEx;
    }

    public List<String> getClassFilters() {
        return this.classFilters;
    }

    public void setClassFilters(List<String> classFilters) {
        this.classFilters = classFilters;
    }

    public Reflections getReflections() {
        return this.reflections;
    }

    public void setReflections(Reflections reflections) {
        this.reflections = reflections;
    }
}

