/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.reduce;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.hiforce.lattice.annotation.model.ReduceType;
import org.hiforce.lattice.model.ability.execute.Reducer;

public class FlatMap<K, V>
extends Reducer<Map<K, V>, Map<K, V>> {
    private final Predicate<Map<K, V>> predicate;

    public FlatMap(@Nonnull Predicate<Map<K, V>> predicate) {
        Objects.requireNonNull(predicate);
        this.predicate = predicate;
    }

    public boolean willBreak(Collection<Map<K, V>> elements) {
        return false;
    }

    public ReduceType reducerType() {
        return ReduceType.ALL;
    }

    public Map<K, V> reduce(Collection<Map<K, V>> elements) {
        if (CollectionUtils.isEmpty(elements)) {
            return Maps.newHashMap();
        }
        HashMap results = Maps.newHashMap();
        for (Map<K, V> element : elements) {
            if (!this.predicate.test(element)) continue;
            results.putAll(element);
        }
        return results;
    }

    public Predicate<Map<K, V>> getPredicate() {
        return this.predicate;
    }
}

