/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.delegate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hiforce.lattice.annotation.model.ProtocolType;
import org.hiforce.lattice.cache.invoke.InvokeCache;
import org.hiforce.lattice.exception.LatticeRuntimeException;
import org.hiforce.lattice.extension.ExtensionRunner;
import org.hiforce.lattice.extension.RemoteExtensionRunnerBuilderBean;
import org.hiforce.lattice.extension.RunnerItemEntry;
import org.hiforce.lattice.message.Message;
import org.hiforce.lattice.model.ability.IAbility;
import org.hiforce.lattice.model.ability.IBusinessExt;
import org.hiforce.lattice.model.business.IBizObject;
import org.hiforce.lattice.model.business.TemplateType;
import org.hiforce.lattice.model.config.BusinessConfig;
import org.hiforce.lattice.model.config.ExtPriority;
import org.hiforce.lattice.model.config.ExtPriorityConfig;
import org.hiforce.lattice.model.context.BizSessionContext;
import org.hiforce.lattice.model.register.BusinessSpec;
import org.hiforce.lattice.model.register.ExtensionSpec;
import org.hiforce.lattice.model.register.RealizationSpec;
import org.hiforce.lattice.model.register.TemplateSpec;
import org.hiforce.lattice.runtime.Lattice;
import org.hiforce.lattice.runtime.ability.BaseLatticeAbility;
import org.hiforce.lattice.runtime.ability.execute.RunnerCollection;
import org.hiforce.lattice.runtime.ability.execute.filter.ExtensionFilter;
import org.hiforce.lattice.runtime.ability.execute.filter.ProductFilter;
import org.hiforce.lattice.runtime.ability.execute.runner.ExtensionJavaRunner;
import org.hiforce.lattice.runtime.ability.register.TemplateRegister;
import org.hiforce.lattice.runtime.cache.LatticeRuntimeCache;
import org.hiforce.lattice.runtime.cache.ability.AbilityCache;
import org.hiforce.lattice.runtime.cache.exension.ExtensionInvokeCache;
import org.hiforce.lattice.runtime.cache.exension.NotExistedRealization;
import org.hiforce.lattice.runtime.cache.index.TemplateIndex;
import org.hiforce.lattice.runtime.cache.key.ExtensionInvokeCacheKey;
import org.hiforce.lattice.runtime.cache.key.ExtensionRunnerCacheKey;
import org.hiforce.lattice.runtime.spi.IRunnerCollectionBuilder;
import org.hiforce.lattice.runtime.spi.LatticeRuntimeSpiFactory;
import org.hiforce.lattice.runtime.utils.SpringApplicationContextHolder;
import org.hiforce.lattice.utils.BizCodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseLatticeAbilityDelegate {
    private static final Logger log = LoggerFactory.getLogger(BaseLatticeAbilityDelegate.class);
    public static final Object NULL_OBJECT = new Object();
    private final BaseLatticeAbility ability;

    public BaseLatticeAbilityDelegate(BaseLatticeAbility ability) {
        this.ability = ability;
    }

    private BusinessConfig loadBusinessConfig(String bizCode, ExtensionSpec extension) {
        BusinessConfig businessConfig = Lattice.getInstance().getBusinessConfigByBizCode(bizCode);
        if (null != businessConfig) {
            return businessConfig;
        }
        if (extension.getProtocolType() == ProtocolType.LOCAL) {
            return businessConfig;
        }
        if (!Lattice.getInstance().isSimpleMode()) {
            return businessConfig;
        }
        BusinessSpec businessSpec = TemplateRegister.getInstance().getBusinesses().stream().filter(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)bizCode)).findFirst().orElse(null);
        if (null == businessConfig) {
            businessSpec = new BusinessSpec();
            businessSpec.setCode(bizCode);
            businessSpec.setRemote(true);
            businessSpec.setName("Remote Business [" + bizCode + "]");
            TemplateIndex.getInstance().addTemplateIndex((TemplateSpec)businessSpec);
            TemplateRegister.getInstance().getBusinesses().add(businessSpec);
        }
        Set<ExtensionSpec> remoteExtensionSet = Lattice.getInstance().getAllRegisteredAbilities().stream().flatMap(p -> p.getAbilityInstances().stream()).flatMap(p -> p.getExtensions().stream()).filter(p -> p.getProtocolType() == ProtocolType.REMOTE).collect(Collectors.toSet());
        RealizationSpec realization = new RealizationSpec();
        realization.setCode(businessSpec.getCode());
        realization.setRemote(true);
        businessSpec.getRealizations().add(realization);
        remoteExtensionSet.forEach(p -> realization.getExtensionCodes().add(p.getCode()));
        return Lattice.getInstance().autoAddAndBuildBusinessConfig(businessSpec);
    }

    public <R> RunnerCollection<R> loadExtensionRunners(@Nonnull String extCode, ExtensionFilter filter) {
        String bizCode = this.ability.getContext().getBizCode();
        String scenario = this.ability.getContext().getScenario();
        IBizObject bizObject = this.ability.getContext().getBizObject();
        boolean onlyProduct = !filter.isLoadBusinessExt();
        List<RunnerItemEntry<R>> cachedRunners = null;
        LatticeRuntimeCache runtimeCache = Lattice.getInstance().getRuntimeCache();
        ExtensionSpec extensionSpec = (ExtensionSpec)runtimeCache.getExtensionCache().getExtensionIndex().getKey1Only(extCode);
        if (null == extensionSpec) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0006", new Object[]{extCode});
        }
        BusinessConfig businessConfig = this.loadBusinessConfig(bizCode, extensionSpec);
        if (null == businessConfig) {
            if (Lattice.getInstance().isSimpleMode()) {
                return this.buildDefaultRunnerCollection(extCode, onlyProduct);
            }
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0012", new Object[]{bizCode});
        }
        cachedRunners = this.getCachedExtensionRunners(extensionSpec, businessConfig, filter);
        if (cachedRunners == null) {
            return this.buildDefaultRunnerCollection(extCode, onlyProduct);
        }
        SessionRelatedFilter sessionRelatedFilter = filter == ExtensionFilter.DEFAULT_FILTER ? new NoProductFilterSessionRelatedFilter(filter, bizObject, bizCode) : new SessionRelatedFilter(filter, bizObject, bizCode);
        boolean loadBizExt = filter.isLoadBusinessExt();
        boolean loadDefaultExtension = this.ability.hasDefaultExtension();
        RunnerCollection<R> businessRunnerCollection = RunnerCollection.of(bizObject, this.filterEffectiveRunners(cachedRunners), sessionRelatedFilter, this.getDefaultRunnerProducer(bizCode, extCode, scenario), loadBizExt, loadDefaultExtension);
        return RunnerCollection.combine(this.buildCustomRunnerCollection(extCode, bizObject), businessRunnerCollection);
    }

    private <R> List<RunnerItemEntry<R>> filterEffectiveRunners(List<RunnerItemEntry<R>> runners) {
        ArrayList output = Lists.newArrayList();
        for (RunnerItemEntry runner : runners) {
            if (runner.getTemplate().getType().isVertical()) {
                output.add(runner);
                continue;
            }
            BizSessionContext bizSessionContext = (BizSessionContext)InvokeCache.instance().get(BizSessionContext.class, BizSessionContext.class);
            List effective = (List)bizSessionContext.getEffectiveTemplates().get(this.ability.getContext().getBizCode());
            if (effective.stream().noneMatch(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)runner.getTemplate().getCode()))) continue;
            output.add(runner);
        }
        return runners;
    }

    private <R> RunnerCollection<R> buildCustomRunnerCollection(String extensionCode, IBizObject bizInstance) {
        IRunnerCollectionBuilder runnerCollectionBuilder = LatticeRuntimeSpiFactory.getInstance().getRunnerCollectionBuilder();
        if (!runnerCollectionBuilder.isSupport(this.ability, extensionCode)) {
            return RunnerCollection.of(bizInstance, Lists.newArrayList(), RunnerCollection.ACCEPT_ALL);
        }
        return runnerCollectionBuilder.buildCustomRunnerCollection(this.ability, extensionCode);
    }

    private static boolean isTemplateEffected(String bizCode, TemplateSpec template) {
        if (template.getType() == TemplateType.BUSINESS) {
            return BizCodeUtils.isCodesMatched((String)bizCode, (String)template.getCode());
        }
        BizSessionContext bizSessionContext = (BizSessionContext)InvokeCache.instance().get(BizSessionContext.class, BizSessionContext.class);
        if (null == bizSessionContext) {
            return false;
        }
        List effective = (List)bizSessionContext.getEffectiveTemplates().get(bizCode);
        return !effective.stream().noneMatch(p -> StringUtils.equals((CharSequence)p.getCode(), (CharSequence)template.getCode()));
    }

    private <R> List<RunnerItemEntry<R>> getCachedExtensionRunners(ExtensionSpec extension, BusinessConfig businessConfig, ExtensionFilter filter) {
        String scenario = this.ability.getContext().getScenario();
        String bizCode = this.ability.getContext().getBizCode();
        boolean supportCustomization = this.ability.supportCustomization();
        boolean isHorizontal = !filter.isLoadBusinessExt();
        LatticeRuntimeCache runtimeCache = Lattice.getInstance().getRuntimeCache();
        ExtensionRunnerCacheKey key = new ExtensionRunnerCacheKey(extension.getCode(), bizCode, scenario, supportCustomization, isHorizontal);
        Object result = AbilityCache.getInstance().getCachedExtensionRunner(this.ability.getClass(), key);
        if (result != null) {
            if (result == NULL_OBJECT) {
                return null;
            }
            return (List)result;
        }
        ExtPriorityConfig priorityConfig = businessConfig.getExtensions().stream().filter(p -> StringUtils.equals((CharSequence)p.getExtCode(), (CharSequence)extension.getCode())).findFirst().orElse(null);
        if (null == priorityConfig) {
            AbilityCache.getInstance().doCacheExtensionRunner(this.ability.getClass(), key, NULL_OBJECT);
            return null;
        }
        ArrayList<RunnerItemEntry<R>> extensionRunners = new ArrayList<RunnerItemEntry<R>>();
        for (ExtPriority config : businessConfig.getExtPriorityByCode(extension.getCode(), isHorizontal)) {
            RunnerItemEntry<R> runnerItemEntry;
            if (null == config) continue;
            BizSessionContext bizSessionContext = (BizSessionContext)InvokeCache.instance().get(BizSessionContext.class, BizSessionContext.class);
            if (null == bizSessionContext) {
                runnerItemEntry = this.buildExtensionRunnerItemEntry(extension, config, bizCode, scenario);
                if (null == runnerItemEntry) continue;
                extensionRunners.add(runnerItemEntry);
                continue;
            }
            if (config.getType().isHorizontal() && config.getType().needInstall() && !businessConfig.productInstalled(config.getCode()) || null == (runnerItemEntry = this.buildExtensionRunnerItemEntry(extension, config, bizCode, scenario))) continue;
            extensionRunners.add(runnerItemEntry);
        }
        AbilityCache.getInstance().doCacheExtensionRunner(this.ability.getClass(), key, extensionRunners);
        return extensionRunners;
    }

    private <R> ExtensionRunner<R> buildRemoteExtensionRunner(TemplateSpec template, ExtensionSpec extension, String bizCode, String scenario) {
        if (!template.isRemote()) {
            return this.buildLocalExtensionRunner(template, extension, bizCode, scenario);
        }
        RemoteExtensionRunnerBuilderBean builderBean = (RemoteExtensionRunnerBuilderBean)SpringApplicationContextHolder.getSpringBean(RemoteExtensionRunnerBuilderBean.class);
        if (null == builderBean) {
            throw new LatticeRuntimeException("LATTICE-CORE-RT-0021", new Object[]{extension.getCode()});
        }
        return builderBean.build((IAbility)this.ability, template, extension.getCode(), scenario);
    }

    private <R> ExtensionRunner<R> buildLocalExtensionRunner(TemplateSpec template, ExtensionSpec extension, String bizCode, String scenario) {
        ExtensionJavaRunner extensionJavaRunner = null;
        IBusinessExt extImpl = this.loadExtensionRealization(bizCode, scenario, template, extension.getCode());
        if (null == extImpl) {
            if (log.isInfoEnabled()) {
                log.info("[Lattice]The ExtensionFacade or ExtensionImplement is null. bizCode: [{}], extCode: [{}]", (Object)bizCode, (Object)extension.getCode());
            }
            extensionJavaRunner = null;
        } else {
            extensionJavaRunner = new ExtensionJavaRunner(extension.getCode(), extImpl);
        }
        return extensionJavaRunner;
    }

    private <R> RunnerItemEntry<R> buildExtensionRunnerItemEntry(ExtensionSpec extension, ExtPriority config, String bizCode, String scenario) {
        BusinessSpec template;
        boolean supportCustomization = this.ability.supportCustomization();
        ExtensionJavaRunner runner = null;
        if (null == config) {
            if (log.isInfoEnabled()) {
                log.info(Message.code((String)"LATTICE-CORE-RT-0013", (Object[])new Object[]{extension.getCode(), bizCode}).getText());
            }
            return null;
        }
        Object object = template = config.getType().isVertical() ? this.getBusinessSpec(config.getCode()) : this.getHorizontalTemplateSpec(config.getCode());
        if (supportCustomization) {
            if (extension.getProtocolType() == ProtocolType.LOCAL) {
                runner = this.buildLocalExtensionRunner((TemplateSpec)template, extension, bizCode, scenario);
            } else if (extension.getProtocolType() == ProtocolType.REMOTE) {
                runner = this.buildRemoteExtensionRunner((TemplateSpec)template, extension, bizCode, scenario);
            }
        } else {
            runner = new ExtensionJavaRunner(extension.getCode(), this.ability.getDefaultRealization());
        }
        if (runner != null) {
            return new RunnerItemEntry((IAbility)this.ability, (TemplateSpec)template, runner);
        }
        return null;
    }

    public <R> RunnerCollection<R> buildDefaultRunnerCollection(String extCode, boolean onlyProduct) {
        String bizCode = this.ability.getContext().getBizObject().getBizCode();
        String scenario = this.ability.getContext().getScenario();
        boolean loadBizExt = !onlyProduct;
        boolean loadDefaultExt = this.ability.hasDefaultExtension();
        RunnerCollection runnerCollection = LatticeRuntimeSpiFactory.getInstance().getRunnerCollectionBuilder().buildCustomRunnerCollection(this.ability, extCode);
        if (loadBizExt) {
            RunnerCollection.Producer<R> producer = this.getDefaultRunnerProducer(bizCode, extCode, scenario);
            return RunnerCollection.combine(runnerCollection, producer, loadBizExt, loadDefaultExt);
        }
        return runnerCollection;
    }

    private <R> RunnerCollection.Producer<R> getDefaultRunnerProducer(String bizCode, String extensionCode, String scenario) {
        return () -> {
            ExtensionJavaRunner javaRunner = null;
            BusinessSpec template = this.getBusinessSpec(bizCode);
            if (this.ability.supportCustomization()) {
                IBusinessExt extImpl = this.loadExtensionRealization(bizCode, scenario, (TemplateSpec)template, extensionCode);
                javaRunner = null == extImpl ? null : new ExtensionJavaRunner(extensionCode, extImpl);
            } else if (this.ability.hasDefaultExtension()) {
                javaRunner = new ExtensionJavaRunner(extensionCode, this.ability.getDefaultRealization());
            }
            if (null == javaRunner) {
                return null;
            }
            return new RunnerItemEntry((IAbility)this.ability, (TemplateSpec)template, javaRunner);
        };
    }

    private BusinessSpec getBusinessSpec(String bizCode) {
        return Lattice.getInstance().getAllRegisteredBusinesses().stream().filter(p -> StringUtils.equals((CharSequence)bizCode, (CharSequence)p.getCode())).findFirst().orElse(null);
    }

    private TemplateSpec getHorizontalTemplateSpec(String code) {
        TemplateSpec spec = Lattice.getInstance().getAllRegisteredProducts().stream().filter(p -> StringUtils.equals((CharSequence)code, (CharSequence)p.getCode())).findFirst().orElse(null);
        if (null != spec) {
            return spec;
        }
        return Lattice.getInstance().getAllRegisteredUseCases().stream().filter(p -> StringUtils.equals((CharSequence)code, (CharSequence)p.getCode())).findFirst().orElse(null);
    }

    private IBusinessExt loadExtensionRealization(String bizCode, String scenario, TemplateSpec template, String extPointCode) {
        ExtensionInvokeCacheKey cacheKey = null == template ? null : new ExtensionInvokeCacheKey(scenario, template, extPointCode);
        return this.internalLoadExtensionRealization(cacheKey, bizCode, scenario, template, extPointCode);
    }

    private IBusinessExt internalLoadExtensionRealization(ExtensionInvokeCacheKey cacheKey, String bizCode, String scenario, TemplateSpec template, String extPointCode) {
        IBusinessExt extImpl = ExtensionInvokeCache.getInstance().getCachedExtensionRealization(cacheKey);
        if (extImpl instanceof NotExistedRealization) {
            return null;
        }
        if (extImpl != null) {
            return extImpl;
        }
        if (null == template) {
            if (this.ability.hasDefaultExtension()) {
                return this.ability.getDefaultRealization();
            }
            return null;
        }
        IBusinessExt extFacade = null;
        extFacade = this.findIExtensionPointsFacadeViaScenario(scenario, template, extPointCode);
        if (extFacade != null) {
            extImpl = extFacade.getBusinessExtByCode(extPointCode, scenario);
        } else if (this.ability.hasDefaultExtension()) {
            extImpl = this.ability.getDefaultRealization();
        }
        if (null == extImpl) {
            ExtensionInvokeCache.getInstance().doCacheExtensionRealization(cacheKey, new NotExistedRealization());
            return null;
        }
        return ExtensionInvokeCache.getInstance().doCacheExtensionRealization(cacheKey, extImpl);
    }

    public IBusinessExt findIExtensionPointsFacadeViaScenario(String scenario, TemplateSpec template, String extPointCode) {
        IBusinessExt extFacade;
        block3: {
            IBusinessExt facade;
            List<RealizationSpec> realizationSpecs;
            block4: {
                extFacade = null;
                TemplateIndex templateCache = Lattice.getInstance().getRuntimeCache().getTemplateIndex();
                realizationSpecs = Lattice.getInstance().getAllRegisteredRealizations();
                if (!StringUtils.isEmpty((CharSequence)scenario)) break block4;
                for (RealizationSpec realization : realizationSpecs) {
                    IBusinessExt facade2;
                    if (StringUtils.isNotEmpty((CharSequence)realization.getScenario()) || (facade2 = realization.getBusinessExt()) == null || !BizCodeUtils.isCodeMatched((String)realization.getCode(), (String)template.getCode()) || null == facade2.getBusinessExtByCode(extPointCode, scenario)) continue;
                    extFacade = facade2;
                    break block3;
                }
                break block3;
            }
            for (RealizationSpec realization : realizationSpecs) {
                if (!StringUtils.equals((CharSequence)scenario, (CharSequence)realization.getScenario()) || (facade = realization.getBusinessExt()) == null || !BizCodeUtils.isCodeMatched((String)realization.getCode(), (String)template.getCode()) || null == facade.getBusinessExtByCode(extPointCode, scenario)) continue;
                extFacade = facade;
                break;
            }
            if (null != extFacade) break block3;
            for (RealizationSpec realization : realizationSpecs) {
                if (StringUtils.isNotEmpty((CharSequence)realization.getScenario()) || (facade = realization.getBusinessExt()) == null || !BizCodeUtils.isCodeMatched((String)realization.getCode(), (String)template.getCode()) || null == facade.getBusinessExtByCode(extPointCode, scenario)) continue;
                extFacade = facade;
                break;
            }
        }
        return extFacade;
    }

    private static class NoProductFilterSessionRelatedFilter<R>
    extends SessionRelatedFilter<R> {
        public NoProductFilterSessionRelatedFilter(ExtensionFilter extensionRunnerFilter, IBizObject bizInstance, String bizCode) {
            super(extensionRunnerFilter, bizInstance, bizCode);
        }

        @Override
        public boolean test(RunnerItemEntry<R> entry) {
            return BaseLatticeAbilityDelegate.isTemplateEffected(this.bizObject.getBizCode(), entry.getTemplate());
        }
    }

    private static class SessionRelatedFilter<R>
    implements Predicate<RunnerItemEntry<R>> {
        private ProductFilter productFilter;
        private ExtensionFilter extensionFilter;
        protected IBizObject bizObject;
        protected String bizCode;

        public SessionRelatedFilter(ExtensionFilter extensionFilter, IBizObject bizObject, String bizCode) {
            this.productFilter = extensionFilter.getProductFilter();
            this.extensionFilter = extensionFilter;
            this.bizObject = bizObject;
            this.bizCode = bizCode;
        }

        @Override
        public boolean test(RunnerItemEntry<R> entry) {
            String templateCode = entry.getTemplate().getCode();
            if (null != this.productFilter && !this.productFilter.getAllowedCodes().contains(templateCode)) {
                return false;
            }
            IBizObject bizInstance = this.bizObject;
            return BaseLatticeAbilityDelegate.isTemplateEffected(bizInstance.getBizCode(), entry.getTemplate());
        }
    }
}

