/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.utils;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service(value="latticeSpringApplicationContextHolder")
public class SpringApplicationContextHolder
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringApplicationContextHolder.class);
    private static ApplicationContext context;

    public void setApplicationContext(@NotNull ApplicationContext context) throws BeansException {
        SpringApplicationContextHolder.context = context;
    }

    public static <T> T getSpringBean(String beanName) {
        Validate.notEmpty((CharSequence)beanName, (String)"bean name is required", (Object[])new Object[0]);
        if (null == context) {
            log.warn("spring application context is not injected");
            return null;
        }
        return (T)context.getBean(beanName);
    }

    public static <T> T getSpringBean(@NonNull Class<?> beanClass) {
        if (beanClass == null) {
            throw new NullPointerException("beanClass is marked non-null but is null");
        }
        String beanName = StringUtils.uncapitalize((String)beanClass.getSimpleName());
        Object bean = null;
        try {
            if (null == context) {
                log.warn("[Lattice]spring application context is not injected");
                return null;
            }
            bean = context.getBean(beanClass);
        }
        catch (BeansException e) {
            log.warn("[Lattice]spring application context is not injected by class\uff1a" + beanClass.getName());
            try {
                bean = SpringApplicationContextHolder.getSpringBean(beanName);
            }
            catch (BeansException ex) {
                log.warn("[Lattice]spring application context is not injected by name\uff1a" + beanName);
            }
        }
        return (T)bean;
    }

    public static ApplicationContext getContext() {
        return context;
    }
}

