/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.reduce;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.hiforce.lattice.annotation.model.ReduceType;
import org.hiforce.lattice.model.ability.execute.Reducer;

public class AnyMatch<T>
extends Reducer<T, Boolean> {
    private final Predicate<T> predicate;

    public AnyMatch(@Nonnull Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        this.predicate = predicate;
        this.setResult(false);
    }

    public boolean willBreak(Collection<T> elements) {
        if (CollectionUtils.isEmpty(elements)) {
            return false;
        }
        for (T element : elements) {
            if (!this.predicate.test(element)) continue;
            this.setBreak();
            this.setResult(true);
            return true;
        }
        return false;
    }

    public ReduceType reducerType() {
        return ReduceType.FIRST;
    }

    public Boolean reduce(Collection<T> elements) {
        if (this.isHasBreak()) {
            return (Boolean)this.getResult();
        }
        return false;
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }
}

