/*
 * Decompiled with CFR 0.152.
 */
package org.hiforce.lattice.runtime.ability.reduce;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.hiforce.lattice.model.ability.execute.Reducer;
import org.hiforce.lattice.runtime.ability.reduce.AllMatch;
import org.hiforce.lattice.runtime.ability.reduce.AllMatchNotEmpty;
import org.hiforce.lattice.runtime.ability.reduce.AnyMatch;
import org.hiforce.lattice.runtime.ability.reduce.FirstOf;
import org.hiforce.lattice.runtime.ability.reduce.FlatList;
import org.hiforce.lattice.runtime.ability.reduce.FlatMap;
import org.hiforce.lattice.runtime.ability.reduce.None;
import org.hiforce.lattice.runtime.ability.reduce.NoneMatch;

public class Reducers {
    public static <T> Reducer<T, List<T>> none() {
        return new None();
    }

    public static <T> Reducer<T, T> firstOf(@Nonnull Predicate<T> predicate) {
        return new FirstOf<T>(predicate);
    }

    public static <T> Reducer<T, T> firstOf() {
        return new FirstOf();
    }

    public static <T> Reducer<T, Boolean> allMatch(@Nonnull Predicate<T> predicate) {
        return new AllMatch<T>(predicate);
    }

    public static <T> Reducer<T, Boolean> AllMatchNotEmpty(@Nonnull Predicate<T> predicate) {
        return new AllMatchNotEmpty<T>(predicate);
    }

    public static <T> Reducer<T, Boolean> anyMatch(@Nonnull Predicate<T> predicate) {
        return new AnyMatch<T>(predicate);
    }

    public static <T> Reducer<T, Boolean> noneMatch(@Nonnull Predicate<T> predicate) {
        return new NoneMatch<T>(predicate);
    }

    public static <T> Reducer<List<T>, List<T>> flatList(@Nonnull Predicate<List<T>> predicate) {
        return new FlatList<T>(predicate);
    }

    public static <K, V> Reducer<Map<K, V>, Map<K, V>> flatMap(@Nonnull Predicate<Map<K, V>> predicate) {
        return new FlatMap<K, V>(predicate);
    }
}

